/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.initiator.messagedriven;

import javax.jms.JMSException;
import javax.jms.TextMessage;
import org.apache.log4j.Logger;
import org.ikasan.common.Payload;
import org.ikasan.common.factory.PayloadFactory;
import org.ikasan.framework.component.Event;
import org.ikasan.framework.component.IkasanExceptionHandler;
import org.ikasan.framework.flow.Flow;
import org.ikasan.framework.initiator.messagedriven.JmsMessageDrivenInitiatorImpl;

public class RawMessageDrivenInitiator
extends JmsMessageDrivenInitiatorImpl {
    private static final int DEFAULT_MESSAGE_PRIORITY = 4;
    private Logger logger = Logger.getLogger(RawMessageDrivenInitiator.class);
    protected PayloadFactory payloadFactory;
    private boolean respectPriority;

    public RawMessageDrivenInitiator(String moduleName, String name, Flow flow, IkasanExceptionHandler exceptionHandler, PayloadFactory payloadFactory) {
        super(moduleName, name, flow, exceptionHandler);
        this.payloadFactory = payloadFactory;
    }

    @Override
    protected Event handleTextMessage(TextMessage message) throws JMSException {
        Payload payload = this.payloadFactory.newPayload(message.getJMSMessageID(), message.getText().getBytes());
        Event event = new Event(this.moduleName, this.name, message.getJMSMessageID(), payload);
        if (this.respectPriority) {
            event.setPriority(message.getJMSPriority());
        } else {
            event.setPriority(4);
        }
        return event;
    }

    @Override
    protected Logger getLogger() {
        return this.logger;
    }

    public void setRespectPriority(boolean respectPriority) {
        this.respectPriority = respectPriority;
    }

    public boolean isRespectPriority() {
        return this.respectPriority;
    }
}

