/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.initiator;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.ikasan.common.Payload;
import org.ikasan.common.factory.PayloadFactory;
import org.ikasan.framework.component.Event;
import org.ikasan.framework.component.IkasanExceptionHandler;
import org.ikasan.framework.flow.Flow;
import org.ikasan.framework.initiator.AbstractInitiator;
import org.ikasan.framework.initiator.Initiator;
import org.ikasan.framework.initiator.InitiatorOperationException;
import org.ikasan.framework.initiator.InitiatorState;

public class SimpleInitiator
extends AbstractInitiator
implements Initiator {
    public static final String SIMPLE_INITIATOR_TYPE = "SimpleInitiator";
    private Logger logger = Logger.getLogger(Logger.class);
    private boolean available = false;
    private String initiatorName;
    private String moduleName;
    private PayloadFactory payloadFactory;
    private Flow flow;

    public SimpleInitiator(String initiatorName, String moduleName, PayloadFactory payloadFactory, Flow flow, IkasanExceptionHandler exceptionHandler) {
        super(moduleName, initiatorName, flow, exceptionHandler);
        this.payloadFactory = payloadFactory;
    }

    public boolean initiate(String originationId, String payloadContent) {
        if (!this.available) {
            throw new IllegalStateException("Initiator is not available for business");
        }
        Payload singlePayload = this.payloadFactory.newPayload(originationId, payloadContent.getBytes());
        ArrayList<Event> events = new ArrayList<Event>();
        events.add(new Event(this.moduleName, this.name, originationId, singlePayload));
        this.invokeFlow(events);
        return true;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    @Override
    public Flow getFlow() {
        return this.flow;
    }

    @Override
    public String getName() {
        return this.initiatorName;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public boolean isRecovering() {
        return false;
    }

    @Override
    public boolean isRunning() {
        return this.isAvailable();
    }

    @Override
    public void start() {
        this.available = true;
    }

    @Override
    public void stop() {
        this.available = false;
    }

    public void setBeanName(String beanName) {
        this.initiatorName = beanName;
    }

    @Override
    public InitiatorState getState() {
        return this.available ? InitiatorState.RUNNING : InitiatorState.STOPPED;
    }

    @Override
    public String getType() {
        return SIMPLE_INITIATOR_TYPE;
    }

    @Override
    public Integer getRetryCount() {
        return null;
    }

    @Override
    protected void stopInitiator() throws InitiatorOperationException {
    }

    @Override
    protected void cancelRetryCycle() {
    }

    @Override
    protected void completeRetryCycle() {
    }

    @Override
    protected Logger getLogger() {
        return this.logger;
    }

    @Override
    protected void startInitiator() throws InitiatorOperationException {
    }

    @Override
    protected void startRetryCycle(Integer maxAttempts, long delay) throws InitiatorOperationException {
    }
}

