/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.initiator;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.ikasan.framework.component.Event;
import org.ikasan.framework.component.IkasanExceptionHandler;
import org.ikasan.framework.configuration.service.ConfigurationException;
import org.ikasan.framework.error.service.ErrorLoggingService;
import org.ikasan.framework.event.exclusion.service.ExcludedEventService;
import org.ikasan.framework.exception.ExcludeEventAction;
import org.ikasan.framework.exception.IkasanExceptionAction;
import org.ikasan.framework.exception.RetryAction;
import org.ikasan.framework.exception.StopAction;
import org.ikasan.framework.flow.Flow;
import org.ikasan.framework.flow.invoker.FlowInvocationContext;
import org.ikasan.framework.initiator.AbortTransactionException;
import org.ikasan.framework.initiator.Initiator;
import org.ikasan.framework.initiator.InitiatorOperationException;
import org.ikasan.framework.initiator.InitiatorState;
import org.ikasan.framework.monitor.MonitorListener;

public abstract class AbstractInitiator
implements Initiator {
    public static final String EXCEPTION_ACTION_IMPLIED_ROLLBACK = "Exception Action implied rollback";
    public static final String UNSUPPORTED_EXCLUDE_ENCONTERED = "Unsupported EXCLUDE action encountered";
    protected List<MonitorListener> monitorListeners = new ArrayList<MonitorListener>();
    protected String moduleName;
    protected String name;
    protected Flow flow;
    protected boolean error = false;
    protected boolean stopping = false;
    protected Integer retryCount = null;
    protected IkasanExceptionHandler exceptionHandler;
    protected ErrorLoggingService errorLoggingService;
    protected ExcludedEventService excludedEventService;
    protected Set<String> exclusions = new HashSet<String>();
    private long handledEventCount = 0L;
    private Date lastEventTime = null;

    public AbstractInitiator(String moduleName, String name, Flow flow, IkasanExceptionHandler exceptionHandler) {
        this.moduleName = moduleName;
        this.name = name;
        this.flow = flow;
        this.exceptionHandler = exceptionHandler;
    }

    public void addListener(MonitorListener monitorListener) {
        this.monitorListeners.add(monitorListener);
    }

    public void removeListener(MonitorListener monitorListener) {
        this.monitorListeners.remove(monitorListener);
    }

    protected void notifyMonitorListeners() {
        for (MonitorListener monitorListener : this.monitorListeners) {
            monitorListener.notify(this.getState().getName());
        }
    }

    @Override
    public IkasanExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public List<MonitorListener> getMonitorListeners() {
        return new ArrayList<MonitorListener>(this.monitorListeners);
    }

    @Override
    public InitiatorState getState() {
        InitiatorState result = null;
        if (this.isRunning()) {
            result = InitiatorState.RUNNING;
            if (this.isRecovering()) {
                result = InitiatorState.RECOVERING;
            }
        } else {
            result = InitiatorState.STOPPED;
            if (this.isError()) {
                result = InitiatorState.ERROR;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws InitiatorOperationException {
        this.stopping = false;
        this.error = false;
        try {
            this.flow.start();
            this.startInitiator();
        }
        catch (ConfigurationException e) {
            this.logError(null, e, this.moduleName, null);
            this.error = true;
        }
        finally {
            this.notifyMonitorListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws InitiatorOperationException {
        this.stopping = true;
        if (this.isRecovering()) {
            this.cancelRetryCycle();
        }
        try {
            this.stopInitiator();
            this.flow.stop();
        }
        finally {
            this.notifyMonitorListeners();
        }
    }

    protected void invokeFlow(List<Event> events) {
        IkasanExceptionAction exceptionAction = null;
        String currentEventId = null;
        if (events != null && events.size() > 0) {
            for (Event event : events) {
                currentEventId = event.getId();
                if (this.supportsExclusions() && this.exclusions.contains(currentEventId)) {
                    this.excludedEventService.excludeEvent(event, this.moduleName, this.flow.getName());
                    this.exclusions.remove(currentEventId);
                    continue;
                }
                FlowInvocationContext flowInvocationContext = new FlowInvocationContext();
                try {
                    this.flow.invoke(flowInvocationContext, event);
                    ++this.handledEventCount;
                    this.lastEventTime = new Date();
                }
                catch (Throwable throwable) {
                    String lastComponentName = flowInvocationContext.getLastComponentName();
                    exceptionAction = this.exceptionHandler.handleThrowable(lastComponentName, throwable);
                    this.logError(event, throwable, lastComponentName, exceptionAction);
                    break;
                }
            }
        }
        this.handleAction(exceptionAction, currentEventId);
    }

    protected void logError(Event event, Throwable throwable, String componentName, IkasanExceptionAction exceptionAction) {
        if (this.errorLoggingService != null) {
            String actionTaken = null;
            if (exceptionAction != null) {
                actionTaken = exceptionAction.toString();
                if (exceptionAction instanceof RetryAction) {
                    actionTaken = actionTaken + " retryCount [" + this.retryCount + "]";
                }
            }
            if (event != null) {
                this.errorLoggingService.logError(throwable, this.moduleName, this.flow.getName(), componentName, event, actionTaken);
            } else {
                this.errorLoggingService.logError(throwable, this.moduleName, this.name, actionTaken);
            }
        } else {
            this.getLogger().warn((Object)("exception caught by initiator [" + this.moduleName + "." + this.name + "], but no errorLoggingService available. Using default log."), throwable);
        }
    }

    protected void invokeFlow(Event event) {
        ArrayList<Event> events = null;
        if (event != null) {
            events = new ArrayList<Event>();
            events.add(event);
        }
        this.invokeFlow(events);
    }

    protected void handleAction(IkasanExceptionAction action, String eventId) {
        try {
            if (action != null) {
                if (action instanceof StopAction) {
                    this.stopInError();
                    throw new AbortTransactionException(EXCEPTION_ACTION_IMPLIED_ROLLBACK);
                }
                if (action instanceof ExcludeEventAction) {
                    if (!this.supportsExclusions()) {
                        this.getLogger().error((Object)"Initiator that doesnt support Exclusions was asked to handle an EXCLUDE! Switching to rollback and stop instead!");
                        this.stopInError();
                        throw new AbortTransactionException(UNSUPPORTED_EXCLUDE_ENCONTERED);
                    }
                    this.exclusions.add(eventId);
                } else if (!this.stopping) {
                    RetryAction retryAction = (RetryAction)action;
                    Integer maxAttempts = retryAction.getMaxRetries();
                    long delay = retryAction.getDelay();
                    this.handleRetry(maxAttempts, delay);
                }
                throw new AbortTransactionException(EXCEPTION_ACTION_IMPLIED_ROLLBACK);
            }
            this.resume();
        }
        catch (InitiatorOperationException e) {
            this.getLogger().fatal((Object)e);
            this.stopInError();
            throw e;
        }
    }

    protected void handleRetry(Integer maxAttempts, long delay) throws InitiatorOperationException {
        if (this.retryWouldExceedLimit(maxAttempts, this.retryCount)) {
            this.stopInError();
            this.getLogger().warn((Object)("Initiator [" + this.moduleName + "-" + this.name + "] stopped. Retry [" + this.retryCount + "/" + (maxAttempts < 0 ? "unlimited" : maxAttempts) + "] failed after max attempts. " + "Manual intervention required."));
        } else if (this.isRecovering()) {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info((Object)("Initiator [" + this.moduleName + "-" + this.name + "] failed retry [" + this.retryCount + "/" + (maxAttempts < 0 ? "unlimited" : maxAttempts) + "]. Next retry at approx [" + new Date(System.currentTimeMillis() + delay) + "]."));
            }
            this.retryCount = this.retryCount + 1;
            this.continueRetryCycle(delay);
        } else {
            this.startRetryCycle(maxAttempts, delay);
            this.retryCount = 0;
            this.notifyMonitorListeners();
        }
    }

    private boolean retryWouldExceedLimit(Integer maxAttempts, Integer attemptCount) {
        Integer thisAttemptCount = attemptCount == null ? -1 : attemptCount;
        return maxAttempts != null && maxAttempts != RetryAction.RETRY_INFINITE && maxAttempts <= thisAttemptCount + 1;
    }

    protected void resume() throws InitiatorOperationException {
        if (this.isRecovering()) {
            this.completeRetryCycle();
            this.notifyMonitorListeners();
        }
    }

    protected void stopInError() {
        this.error = true;
        this.stop();
    }

    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public Integer getRetryCount() {
        return this.retryCount;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Flow getFlow() {
        return this.flow;
    }

    @Override
    public boolean isError() {
        return this.error;
    }

    public boolean isStopping() {
        return this.stopping;
    }

    public void setErrorLoggingService(ErrorLoggingService errorLoggingService) {
        this.errorLoggingService = errorLoggingService;
    }

    protected abstract Logger getLogger();

    protected abstract void completeRetryCycle();

    protected abstract void cancelRetryCycle();

    protected abstract void startInitiator() throws InitiatorOperationException;

    protected abstract void stopInitiator() throws InitiatorOperationException;

    protected abstract void startRetryCycle(Integer var1, long var2) throws InitiatorOperationException;

    protected void continueRetryCycle(long delay) {
    }

    public void setExcludedEventService(ExcludedEventService excludedEventService) {
        this.excludedEventService = excludedEventService;
    }

    public boolean supportsExclusions() {
        return this.excludedEventService != null;
    }

    public Set<String> getExclusions() {
        return new HashSet<String>(this.exclusions);
    }

    @Override
    public long getHandledEventCount() {
        return this.handledEventCount;
    }

    @Override
    public Date getLastEventTime() {
        return this.lastEventTime;
    }
}

