/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.flow.invoker;

import java.util.List;
import org.apache.log4j.Logger;
import org.ikasan.framework.component.Event;
import org.ikasan.framework.component.endpoint.Endpoint;
import org.ikasan.framework.component.routing.Router;
import org.ikasan.framework.component.sequencing.Sequencer;
import org.ikasan.framework.component.transformation.Transformer;
import org.ikasan.framework.flow.FlowComponent;
import org.ikasan.framework.flow.FlowElement;
import org.ikasan.framework.flow.InvalidFlowException;
import org.ikasan.framework.flow.event.listener.FlowEventListener;
import org.ikasan.framework.flow.invoker.FlowElementInvoker;
import org.ikasan.framework.flow.invoker.FlowInvocationContext;

public class VisitingFlowElementInvoker
implements FlowElementInvoker {
    private static final Logger logger = Logger.getLogger(VisitingFlowElementInvoker.class);
    private FlowEventListener flowEventListener;

    public void setFlowEventListener(FlowEventListener flowEventListener) {
        this.flowEventListener = flowEventListener;
    }

    @Override
    public void invoke(FlowInvocationContext flowInvocationContext, Event event, String moduleName, String flowName, FlowElement flowElement) {
        while (flowElement != null) {
            flowInvocationContext.addInvokedComponentName(flowElement.getComponentName());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking [" + flowElement.getComponentName() + "] of [" + flowName + "] " + event.idToString()));
            }
            this.notifyListenersBeforeElement(event, moduleName, flowName, flowElement);
            FlowComponent flowComponent = flowElement.getFlowComponent();
            if (flowComponent instanceof Transformer) {
                this.handleTransformer(event, moduleName, flowName, flowElement);
                FlowElement previousFlowElement = flowElement;
                if ((flowElement = this.getDefaultTransition(flowElement)) != null) continue;
                logger.error((Object)"transformer is last element in flow!");
                throw new InvalidFlowException("FlowElement [" + previousFlowElement.getComponentName() + "] contains a Transfomer, but it has no default transition! " + "Transformers should never be the last component in a flow");
            }
            if (flowComponent instanceof Endpoint) {
                this.handleEndpoint(event, moduleName, flowName, flowElement);
                flowElement = this.getDefaultTransition(flowElement);
                continue;
            }
            if (flowComponent instanceof Router) {
                this.handleRouter(flowInvocationContext, event, moduleName, flowName, flowElement);
                break;
            }
            if (flowComponent instanceof Sequencer) {
                this.handleSequencer(flowInvocationContext, event, moduleName, flowName, flowElement);
                break;
            }
            throw new RuntimeException("Unhandled FlowComponent type:" + flowComponent.getClass());
        }
    }

    private void handleSequencer(FlowInvocationContext flowInvocationContext, Event event, String moduleName, String flowName, FlowElement flowElement) {
        FlowElement nextFlowElement;
        Sequencer sequencer = (Sequencer)flowElement.getFlowComponent();
        List<Event> events = sequencer.onEvent(event, moduleName, flowElement.getComponentName());
        if (events != null) {
            this.notifyListenersAfterSequencerElement(events, moduleName, flowName, flowElement);
        }
        if ((nextFlowElement = this.getDefaultTransition(flowElement)) == null) {
            logger.error((Object)"sequencer is last element in flow!");
            throw new InvalidFlowException("FlowElement [" + flowElement.getComponentName() + "] contains a Sequencer, but it has no default transition! " + "Sequencers should never be the last component in a flow");
        }
        if (events != null) {
            for (Event constituentEvent : events) {
                this.invoke(flowInvocationContext, this.spawnEvent(constituentEvent), moduleName, flowName, nextFlowElement);
            }
        }
    }

    private void notifyListenersBeforeElement(Event event, String moduleName, String flowName, FlowElement flowElement) {
        if (this.flowEventListener != null) {
            try {
                this.flowEventListener.beforeFlowElement(moduleName, flowName, flowElement, event);
            }
            catch (Throwable t) {
                logger.error((Object)("flowEventListener caught throwable before flowElement [" + flowElement + "], exception is[" + t + "]"), t);
                for (StackTraceElement stackTraceElement : t.getStackTrace()) {
                    logger.error((Object)stackTraceElement);
                }
            }
        }
    }

    private void notifyListenersAfterElement(Event event, String moduleName, String flowName, FlowElement flowElement) {
        if (this.flowEventListener != null) {
            try {
                this.flowEventListener.afterFlowElement(moduleName, flowName, flowElement, event);
            }
            catch (Throwable t) {
                logger.error((Object)("flowEventListener caught throwable after flowElement [" + flowElement + "], exception is[" + t + "]"), t);
                for (StackTraceElement stackTraceElement : t.getStackTrace()) {
                    logger.error((Object)stackTraceElement);
                }
            }
        }
    }

    private void notifyListenersAfterSequencerElement(List<Event> events, String moduleName, String flowName, FlowElement flowElement) {
        for (Event event : events) {
            this.notifyListenersAfterElement(event, moduleName, flowName, flowElement);
        }
    }

    private void handleRouter(FlowInvocationContext flowInvocationContext, Event event, String moduleName, String flowName, FlowElement flowElement) {
        Router router = (Router)flowElement.getFlowComponent();
        List<String> targetNames = router.onEvent(event);
        this.notifyListenersAfterElement(event, moduleName, flowName, flowElement);
        for (String targetName : targetNames) {
            FlowElement nextFlowElement = flowElement.getTransition(targetName);
            if (nextFlowElement == null) {
                logger.error((Object)"router is last element in flow!");
                throw new InvalidFlowException("FlowElement [" + flowElement.getComponentName() + "] contains a Router, but it does not have a transition mapped for that Router's target[" + targetName + "] " + "All Router targets must be mapped to transitions in their enclosing FlowElement");
            }
            this.invoke(flowInvocationContext, this.spawnEvent(event), moduleName, flowName, nextFlowElement);
        }
    }

    private void handleEndpoint(Event event, String moduleName, String flowName, FlowElement flowElement) {
        Endpoint endpoint = (Endpoint)flowElement.getFlowComponent();
        endpoint.onEvent(event);
        this.notifyListenersAfterElement(event, moduleName, flowName, flowElement);
    }

    private void handleTransformer(Event event, String moduleName, String flowName, FlowElement flowElement) {
        Transformer transformer = (Transformer)flowElement.getFlowComponent();
        transformer.onEvent(event);
        this.notifyListenersAfterElement(event, moduleName, flowName, flowElement);
    }

    private Event spawnEvent(Event originalEvent) {
        Event clone = null;
        try {
            clone = originalEvent.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return clone;
    }

    private FlowElement getDefaultTransition(FlowElement flowElement) {
        return flowElement.getTransition("default");
    }
}

