/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.flow.event.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ikasan.framework.component.Event;
import org.ikasan.framework.event.wiretap.service.WiretapService;
import org.ikasan.framework.flow.event.service.FlowEventJob;

public class WiretapEventJob
implements FlowEventJob {
    private WiretapService wiretapService;
    public static final String TIME_TO_LIVE_PARAM = "timeToLive";
    private static final Long ONE_WEEK = 10080L;
    private static final Logger logger = Logger.getLogger(WiretapEventJob.class);
    private static final List<String> parameterNames = new ArrayList<String>();

    public WiretapEventJob(WiretapService wiretapService) {
        this.wiretapService = wiretapService;
    }

    @Override
    public void execute(String location, String moduleName, String flowName, Event event, Map<String, String> params) {
        Long timeToLive = ONE_WEEK;
        String timeToLiveString = params.get(TIME_TO_LIVE_PARAM);
        if (timeToLiveString != null) {
            try {
                timeToLive = Long.parseLong(timeToLiveString);
            }
            catch (NumberFormatException nfe) {
                logger.error((Object)("timeToLive could not be parsed [" + timeToLiveString + "]"));
            }
        }
        logger.info((Object)("about to wiretap with timeToLive=[" + timeToLive + "]"));
        this.wiretapService.tapEvent(event, location, moduleName, flowName, timeToLive);
    }

    @Override
    public List<String> getParameters() {
        return new ArrayList<String>(parameterNames);
    }

    @Override
    public Map<String, String> validateParameters(Map<String, String> params) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (!params.containsKey(TIME_TO_LIVE_PARAM)) {
            result.put(TIME_TO_LIVE_PARAM, "timeToLive is mandatory");
        } else {
            String timeToLiveString = params.get(TIME_TO_LIVE_PARAM);
            try {
                Long timeToLive = Long.parseLong(timeToLiveString);
                if (timeToLive < 0L) {
                    result.put(TIME_TO_LIVE_PARAM, "timeToLive must be greater than 0");
                }
            }
            catch (NumberFormatException nfe) {
                result.put(TIME_TO_LIVE_PARAM, "timeToLive is not a valid number");
            }
        }
        return result;
    }

    static {
        parameterNames.add(TIME_TO_LIVE_PARAM);
    }
}

