/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.flow.event.model;

import java.util.HashMap;
import java.util.Map;
import org.ikasan.framework.flow.event.model.TriggerRelationship;

public class Trigger {
    private String flowElementName;
    private String flowName;
    private Long id;
    private String jobName;
    private String moduleName;
    private Map<String, String> params = new HashMap<String, String>();
    private TriggerRelationship relationship;

    private Trigger() {
    }

    public Trigger(String moduleName, String flowName, String relationshipDescription, String jobName) {
        this.jobName = jobName;
        this.moduleName = moduleName;
        this.setRelationshipDescription(relationshipDescription);
        this.flowName = flowName;
    }

    public Trigger(String moduleName, String flowName, String relationshipDescription, String jobName, Map<String, String> params) {
        this(moduleName, flowName, relationshipDescription, jobName);
        this.params.putAll(params);
    }

    public Trigger(String moduleName, String flowName, String relationshipDescription, String jobName, String flowElementName) {
        this(moduleName, flowName, relationshipDescription, jobName);
        this.flowElementName = flowElementName;
    }

    public Trigger(String moduleName, String flowName, String relationshipDescription, String jobName, String flowElementName, Map<String, String> params) {
        this(moduleName, flowName, relationshipDescription, jobName, flowElementName);
        this.params.putAll(params);
    }

    public boolean appliesToFlowElement() {
        return this.flowElementName != null;
    }

    public String getFlowElementName() {
        return this.flowElementName;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public Long getId() {
        return this.id;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public TriggerRelationship getRelationship() {
        return this.relationship;
    }

    private String getRelationshipDescription() {
        return this.relationship.getDescription();
    }

    private void setId(Long id) {
        this.id = id;
    }

    private void setJobName(String jobName) {
        this.jobName = jobName;
    }

    private void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    private void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    private void setFlowElementName(String flowElementName) {
        this.flowElementName = flowElementName;
    }

    private void setParams(Map<String, String> params) {
        this.params = params;
    }

    private void setRelationshipDescription(String relationshipDescription) {
        TriggerRelationship thisRelationship = TriggerRelationship.get(relationshipDescription);
        if (thisRelationship == null) {
            throw new IllegalArgumentException("No such relationship:" + (Object)((Object)this.relationship));
        }
        this.relationship = thisRelationship;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName() + "[");
        sb.append("id=");
        sb.append(this.id);
        sb.append(",");
        sb.append("moduleName=");
        sb.append(this.moduleName);
        sb.append(",");
        sb.append("flowName=");
        sb.append(this.flowName);
        sb.append(",");
        sb.append("flowElementName=");
        sb.append(this.flowElementName);
        sb.append(",");
        sb.append("params=");
        sb.append(this.params);
        sb.append(",");
        sb.append("jobName=");
        sb.append(this.jobName);
        sb.append(",");
        sb.append("relationship=");
        sb.append((Object)this.relationship);
        sb.append("]");
        return sb.toString();
    }
}

