/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.flow.event.listener;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ikasan.framework.component.Event;
import org.ikasan.framework.flow.FlowElement;
import org.ikasan.framework.flow.event.dao.TriggerDao;
import org.ikasan.framework.flow.event.listener.FlowEventListener;
import org.ikasan.framework.flow.event.model.Trigger;
import org.ikasan.framework.flow.event.model.TriggerRelationship;
import org.ikasan.framework.flow.event.service.FlowEventJob;

public class JobAwareFlowEventListener
implements FlowEventListener {
    private static final String AFTER_LOCATION_PREFIX = "after";
    private static final String BEFORE_LOCATION_PREFIX = "before";
    private Map<String, FlowEventJob> flowEventJobs;
    private Map<String, List<Trigger>> triggers = new HashMap<String, List<Trigger>>();
    private TriggerDao triggerDao;
    private static final Logger logger = Logger.getLogger(JobAwareFlowEventListener.class);

    public JobAwareFlowEventListener(Map<String, FlowEventJob> flowEventJobs, TriggerDao triggerDao) {
        this.flowEventJobs = flowEventJobs;
        this.triggerDao = triggerDao;
        for (Trigger dynamicTrigger : triggerDao.findAll()) {
            this.mapTrigger(dynamicTrigger);
        }
    }

    public void addStaticTriggers(List<Trigger> staticTriggers) {
        for (Trigger trigger : staticTriggers) {
            this.addStaticTrigger(trigger);
        }
    }

    public void addStaticTrigger(Trigger trigger) {
        this.mapTrigger(trigger);
    }

    public void addDynamicTrigger(Trigger trigger) {
        this.triggerDao.save(trigger);
        this.mapTrigger(trigger);
    }

    private void mapTrigger(Trigger trigger) {
        String key = this.generateKey(trigger);
        List<Trigger> list = this.triggers.get(key);
        if (list == null) {
            list = new ArrayList<Trigger>();
            this.triggers.put(key, list);
        }
        list.add(trigger);
    }

    private String generateKey(Trigger trigger) {
        String key = trigger.getModuleName() + trigger.getFlowName() + trigger.getRelationship().getDescription();
        if (trigger.appliesToFlowElement()) {
            key = key + trigger.getFlowElementName();
        }
        return key;
    }

    @Override
    public void beforeFlow(String moduleName, String flowName, Event event) {
        String key = moduleName + flowName + TriggerRelationship.BEFORE.getDescription();
        List<Trigger> beforeFlowTriggers = this.triggers.get(key);
        this.fireTriggers(moduleName, flowName, event, beforeFlowTriggers, "before " + flowName);
    }

    @Override
    public void afterFlow(String moduleName, String flowName, Event event) {
        String key = moduleName + flowName + TriggerRelationship.AFTER.getDescription();
        List<Trigger> afterFlowTriggers = this.triggers.get(key);
        this.fireTriggers(moduleName, flowName, event, afterFlowTriggers, "after " + flowName);
    }

    @Override
    public void beforeFlowElement(String moduleName, String flowName, FlowElement flowElement, Event event) {
        String flowElementName = flowElement.getComponentName();
        String key = moduleName + flowName + TriggerRelationship.BEFORE.getDescription() + flowElementName;
        List<Trigger> beforeElementTriggers = this.triggers.get(key);
        this.fireTriggers(moduleName, flowName, event, beforeElementTriggers, "before " + flowElementName);
    }

    @Override
    public void afterFlowElement(String moduleName, String flowName, FlowElement flowElement, Event event) {
        String flowElementName = flowElement.getComponentName();
        String key = moduleName + flowName + TriggerRelationship.AFTER.getDescription() + flowElementName;
        List<Trigger> afterElementTriggers = this.triggers.get(key);
        this.fireTriggers(moduleName, flowName, event, afterElementTriggers, "after " + flowElementName);
    }

    private void fireTriggers(String moduleName, String flowName, Event event, List<Trigger> associatedTriggers, String location) {
        if (associatedTriggers != null) {
            for (Trigger associatedTrigger : associatedTriggers) {
                String jobName = associatedTrigger.getJobName();
                FlowEventJob flowEventAgent = this.flowEventJobs.get(jobName);
                if (flowEventAgent == null) {
                    logger.warn((Object)("unknown job [" + jobName + "]"));
                    continue;
                }
                flowEventAgent.execute(location, moduleName, flowName, event, new HashMap<String, String>(associatedTrigger.getParams()));
            }
        }
    }

    public List<Trigger> getTriggers(String moduleName, String flowName, TriggerRelationship relationship, String flowElementName) {
        ArrayList<Trigger> result = new ArrayList<Trigger>();
        String key = moduleName + flowName + relationship.getDescription() + flowElementName;
        List<Trigger> mappedTriggers = this.triggers.get(key);
        if (mappedTriggers != null) {
            result.addAll(mappedTriggers);
        }
        return result;
    }

    public void deleteDynamicTrigger(Long triggerId) {
        Trigger trigger = this.triggerDao.findById(triggerId);
        if (trigger == null) {
            logger.warn((Object)("could not find trigger with id [" + triggerId + "]"));
        } else {
            this.unmapTrigger(trigger);
            this.triggerDao.delete(trigger);
        }
    }

    private void unmapTrigger(Trigger trigger) {
        String key = this.generateKey(trigger);
        List<Trigger> list = this.triggers.get(key);
        if (list != null) {
            Trigger mappedTriggerToDelete = null;
            for (Trigger mappedTrigger : list) {
                if (!mappedTrigger.getId().equals(trigger.getId())) continue;
                mappedTriggerToDelete = mappedTrigger;
            }
            if (mappedTriggerToDelete != null) {
                list.remove(mappedTriggerToDelete);
            }
        }
    }

    public Map<String, FlowEventJob> getRegisteredJobs() {
        return new HashMap<String, FlowEventJob>(this.flowEventJobs);
    }
}

