/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.exception.matching;

import java.util.List;
import java.util.Map;
import org.ikasan.framework.component.IkasanExceptionHandler;
import org.ikasan.framework.exception.IkasanExceptionAction;
import org.ikasan.framework.exception.StopAction;
import org.ikasan.framework.exception.matching.ExceptionGroup;

public class MatchingExceptionHandler
implements IkasanExceptionHandler {
    private static final IkasanExceptionAction defaultAction = StopAction.instance();
    private List<ExceptionGroup> exceptionGroupings;
    private Map<String, List<ExceptionGroup>> componentExceptionGroupings;

    public MatchingExceptionHandler(List<ExceptionGroup> exceptionGroupings, Map<String, List<ExceptionGroup>> componentExceptionGroupings) {
        this.exceptionGroupings = exceptionGroupings;
        this.componentExceptionGroupings = componentExceptionGroupings;
    }

    public MatchingExceptionHandler(List<ExceptionGroup> exceptionGroupings) {
        this(exceptionGroupings, null);
    }

    @Override
    public IkasanExceptionAction handleThrowable(String componentName, Throwable throwable) {
        List<ExceptionGroup> thisComponentsGroupings;
        if (this.componentExceptionGroupings != null && (thisComponentsGroupings = this.componentExceptionGroupings.get(componentName)) != null) {
            for (ExceptionGroup exceptionGroup : thisComponentsGroupings) {
                if (!exceptionGroup.includes(throwable)) continue;
                return exceptionGroup.getAction();
            }
        }
        if (this.exceptionGroupings != null) {
            for (ExceptionGroup exceptionGroup : this.exceptionGroupings) {
                if (!exceptionGroup.includes(throwable)) continue;
                return exceptionGroup.getAction();
            }
        }
        return defaultAction;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName() + " [");
        sb.append("exceptionGroupings = [" + this.exceptionGroupings + "]");
        sb.append(", ");
        sb.append("componentExceptionGroupings = [" + this.componentExceptionGroupings + "]");
        sb.append(", ");
        sb.append("defaultAction = [" + defaultAction + "]");
        sb.append("]");
        return sb.toString();
    }
}

