/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.event.wiretap.model;

import java.io.Serializable;
import java.util.Date;

public class WiretapEventHeader
implements Comparable<WiretapEventHeader>,
Serializable {
    private static final long serialVersionUID = -9100792189633886601L;
    protected Long id;
    protected String moduleName;
    protected String flowName;
    protected String componentName;
    protected String eventId;
    protected String payloadId;
    protected Date created;
    protected Date expiry;
    protected transient Long nextByPayload;
    protected transient Long previousByPayload;

    public WiretapEventHeader(String moduleName, String flowName, String componentName, String eventId, String payloadId, Date expiry) {
        Date now;
        this.moduleName = moduleName;
        this.flowName = flowName;
        this.componentName = componentName;
        this.eventId = eventId;
        this.payloadId = payloadId;
        this.expiry = expiry;
        this.created = now = new Date();
    }

    protected WiretapEventHeader() {
    }

    public String getComponentName() {
        return this.componentName;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public Long getId() {
        return this.id;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getPayloadId() {
        return this.payloadId;
    }

    public Date getExpiry() {
        return this.expiry;
    }

    protected void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    protected void setCreated(Date created) {
        this.created = created;
    }

    protected void setEventId(String eventId) {
        this.eventId = eventId;
    }

    protected void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public void setId(Long id) {
        this.id = id;
    }

    protected void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    protected void setPayloadId(String payloadId) {
        this.payloadId = payloadId;
    }

    protected void setExpiry(Date expiry) {
        this.expiry = expiry;
    }

    @Override
    public int compareTo(WiretapEventHeader other) {
        if (this.id == null) {
            return -1;
        }
        return this.id.compareTo(other.getId());
    }

    public Long getNextByPayload() {
        return this.nextByPayload;
    }

    public void setNextByPayload(Long nextByPayload) {
        this.nextByPayload = nextByPayload;
    }

    public Long getPreviousByPayload() {
        return this.previousByPayload;
    }

    public void setPreviousByPayload(Long previousByPayload) {
        this.previousByPayload = previousByPayload;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName() + " [");
        sb.append("id=");
        sb.append(this.id);
        sb.append(",");
        sb.append("moduleName=");
        sb.append(this.moduleName);
        sb.append(",");
        sb.append("flowName=");
        sb.append(this.flowName);
        sb.append(",");
        sb.append("componentName=");
        sb.append(this.componentName);
        sb.append(",");
        sb.append("eventId=");
        sb.append(this.eventId);
        sb.append(",");
        sb.append("payloadId=");
        sb.append(this.payloadId);
        sb.append(",");
        sb.append("expiry=");
        sb.append(this.expiry);
        sb.append("]");
        return sb.toString();
    }
}

