/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.event.exclusion.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.ikasan.framework.component.Event;
import org.ikasan.framework.error.model.ErrorOccurrence;
import org.ikasan.framework.error.service.ErrorLoggingService;
import org.ikasan.framework.event.exclusion.dao.ExcludedEventDao;
import org.ikasan.framework.event.exclusion.model.ExcludedEvent;
import org.ikasan.framework.event.exclusion.service.ExcludedEventListener;
import org.ikasan.framework.event.exclusion.service.ExcludedEventService;
import org.ikasan.framework.flow.Flow;
import org.ikasan.framework.flow.invoker.FlowInvocationContext;
import org.ikasan.framework.initiator.AbortTransactionException;
import org.ikasan.framework.initiator.Initiator;
import org.ikasan.framework.management.search.PagedSearchResult;
import org.ikasan.framework.module.Module;
import org.ikasan.framework.module.service.ModuleService;

public class ExcludedEventServiceImpl
implements ExcludedEventService {
    private List<ExcludedEventListener> excludedEventListeners = new ArrayList<ExcludedEventListener>();
    private ExcludedEventDao excludedEventDao;
    private ErrorLoggingService errorLoggingService;
    private ModuleService moduleService;
    private TransactionManager transactionManager;
    private Logger logger = Logger.getLogger(ExcludedEventServiceImpl.class);

    public ExcludedEventServiceImpl(ExcludedEventDao excludedEventDao, ErrorLoggingService errorLoggingService, List<ExcludedEventListener> listeners, ModuleService moduleService) {
        this.excludedEventDao = excludedEventDao;
        this.excludedEventListeners.addAll(listeners);
        this.moduleService = moduleService;
        this.errorLoggingService = errorLoggingService;
    }

    @Override
    public void excludeEvent(Event event, String moduleName, String flowName) {
        Date exclusionTime = new Date();
        this.logger.info((Object)("excluding event from module:" + moduleName + ", flow:" + flowName));
        this.excludedEventDao.save(new ExcludedEvent(event, moduleName, flowName, exclusionTime));
        for (ExcludedEventListener excludedEventListener : this.excludedEventListeners) {
            excludedEventListener.notifyExcludedEvent(event);
        }
    }

    @Override
    public PagedSearchResult<ExcludedEvent> getExcludedEvents(int pageNo, int pageSize, String orderBy, boolean orderAscending, String moduleName, String flowName) {
        if (pageNo < 0) {
            throw new IllegalArgumentException("pageNo must be >= 0");
        }
        if (pageSize < 1) {
            throw new IllegalArgumentException("pageSize must be > 0");
        }
        return this.excludedEventDao.findExcludedEvents(pageNo, pageSize, orderBy, orderAscending, moduleName, flowName);
    }

    @Override
    public ExcludedEvent getExcludedEvent(String eventId) {
        ExcludedEvent excludedEvent = this.excludedEventDao.getExcludedEvent(eventId, false);
        if (excludedEvent != null) {
            List<ErrorOccurrence> errorOccurrences = this.errorLoggingService.getErrorOccurrences(eventId);
            excludedEvent.setErrorOccurrences(errorOccurrences);
        }
        return excludedEvent;
    }

    @Override
    public void resubmit(String eventId, String resubmitter) {
        ExcludedEvent excludedEvent;
        this.logger.info((Object)("resubmit called with eventId [" + eventId + "], resubmitter [" + resubmitter + "]"));
        if (this.transactionManager != null) {
            try {
                int status = this.transactionManager.getStatus();
                if (0 != status) {
                    this.logger.warn((Object)"Warning! Resubmission invoked outside of an active transaction!");
                }
            }
            catch (SystemException e) {
                this.logger.error((Object)e);
            }
        }
        if ((excludedEvent = this.excludedEventDao.getExcludedEvent(eventId, false)) == null) {
            throw new IllegalArgumentException("Cannot find Excluded Event id:" + eventId);
        }
        if (excludedEvent.isResolved()) {
            throw new IllegalStateException("Attempt made to resubmit event:" + eventId);
        }
        Module module = this.moduleService.getModule(excludedEvent.getModuleName());
        if (module == null) {
            throw new IllegalArgumentException("unknown Module:" + excludedEvent.getModuleName());
        }
        Flow flow = module.getFlows().get(excludedEvent.getFlowName());
        if (flow == null) {
            throw new IllegalArgumentException("unknown Flow" + excludedEvent.getFlowName());
        }
        for (Initiator initiator : module.getInitiators()) {
            this.logger.info((Object)("considering initiator [" + initiator + "]"));
            if (!initiator.getFlow().equals(flow)) continue;
            this.logger.info((Object)("matched flow [" + flow + "]"));
            if (initiator.isRunning()) continue;
            throw new IllegalStateException("Cannot resubmit to Flow [" + flow.getName() + "] as not all Initiators are running");
        }
        this.logger.info((Object)"all good!");
        Event event = excludedEvent.getEvent();
        FlowInvocationContext flowInvocationContext = new FlowInvocationContext();
        try {
            flow.invoke(flowInvocationContext, event);
        }
        catch (Throwable throwable) {
            try {
                Event clonedEvent = event.clone();
                this.errorLoggingService.logError(throwable, excludedEvent.getModuleName(), excludedEvent.getFlowName(), flowInvocationContext.getLastComponentName(), clonedEvent, null);
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
            throw new AbortTransactionException("Resubmission failed!", throwable);
        }
        excludedEvent = this.excludedEventDao.getExcludedEvent(eventId, true);
        excludedEvent.resolveAsResubmitted(resubmitter);
        this.excludedEventDao.save(excludedEvent);
    }

    @Override
    public void cancel(String eventId, String canceller) {
        ExcludedEvent excludedEvent = this.excludedEventDao.getExcludedEvent(eventId, true);
        if (excludedEvent == null) {
            throw new IllegalArgumentException("Cannot find Excluded Event id:" + eventId);
        }
        if (excludedEvent.isResolved()) {
            throw new IllegalStateException("Attempt made to resubmit event:" + eventId);
        }
        Module module = this.moduleService.getModule(excludedEvent.getModuleName());
        if (module == null) {
            throw new IllegalArgumentException("unknown Module:" + excludedEvent.getModuleName());
        }
        excludedEvent.resolveAsCancelled(canceller);
        this.excludedEventDao.save(excludedEvent);
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }
}

