/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.error.service;

import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.ikasan.framework.component.Event;
import org.ikasan.framework.error.dao.ErrorOccurrenceDao;
import org.ikasan.framework.error.model.ErrorOccurrence;
import org.ikasan.framework.error.service.ErrorLoggingService;
import org.ikasan.framework.error.service.ErrorOccurrenceListener;
import org.ikasan.framework.event.exclusion.dao.ExcludedEventDao;
import org.ikasan.framework.management.search.PagedSearchResult;

public class DefaultErrorLoggingServiceImpl
implements ErrorLoggingService {
    private static final long MILLISECONDS_IN_A_DAY = 86400000L;
    private Logger logger = Logger.getLogger(DefaultErrorLoggingServiceImpl.class);
    private long errorTimeToLiveDays = 7L;
    private ErrorOccurrenceDao errorOccurrenceDao;
    private ExcludedEventDao excludedEventDao;
    private List<ErrorOccurrenceListener> errorOccurrenceListeners = new ArrayList<ErrorOccurrenceListener>();
    private URL baseUrl;

    public DefaultErrorLoggingServiceImpl(ErrorOccurrenceDao errorOccurrenceDao, ExcludedEventDao excludedEventDao, URL baseUrl) {
        this.errorOccurrenceDao = errorOccurrenceDao;
        this.excludedEventDao = excludedEventDao;
        this.baseUrl = baseUrl;
    }

    public DefaultErrorLoggingServiceImpl(ErrorOccurrenceDao errorOccurrenceDao, ExcludedEventDao excludedEventDao, URL baseUrl, List<ErrorOccurrenceListener> errorOccurrenceListeners) {
        this(errorOccurrenceDao, excludedEventDao, baseUrl);
        this.errorOccurrenceListeners = new ArrayList<ErrorOccurrenceListener>();
        this.errorOccurrenceListeners.addAll(errorOccurrenceListeners);
    }

    public DefaultErrorLoggingServiceImpl(ErrorOccurrenceDao errorOccurrenceDao, ExcludedEventDao excludedEventDao, URL baseURl, ErrorOccurrenceListener errorOccurrenceListener) {
        this(errorOccurrenceDao, excludedEventDao, baseURl);
        this.errorOccurrenceListeners = new ArrayList<ErrorOccurrenceListener>();
        this.errorOccurrenceListeners.add(errorOccurrenceListener);
    }

    @Override
    public void logError(Throwable throwable, String moduleName, String flowName, String flowElementName, Event currentEvent, String actionTaken) {
        ErrorOccurrence errorOccurrence = new ErrorOccurrence(throwable, currentEvent, moduleName, flowName, flowElementName, this.calculateExpiry(), actionTaken);
        this.persistAndNotifyListeners(errorOccurrence);
    }

    private Date calculateExpiry() {
        return new Date(System.currentTimeMillis() + this.errorTimeToLiveDays * 86400000L);
    }

    private void persistAndNotifyListeners(ErrorOccurrence errorOccurrence) {
        this.logger.info((Object)"logging error");
        this.errorOccurrenceDao.save(errorOccurrence);
        String url = this.baseUrl + "/admin/errors/viewError.htm?errorId=" + errorOccurrence.getId();
        this.logger.info((Object)("setting URL as:" + url));
        errorOccurrence.setUrl(url);
        if (this.errorOccurrenceListeners != null) {
            for (ErrorOccurrenceListener errorOccurrenceListener : this.errorOccurrenceListeners) {
                errorOccurrenceListener.notifyErrorOccurrence(errorOccurrence);
            }
        }
    }

    @Override
    public PagedSearchResult<ErrorOccurrence> getErrors(int pageNo, int pageSize, String orderBy, boolean orderAscending, String moduleName, String flowName) {
        if (pageNo < 0) {
            throw new IllegalArgumentException("pageNo must be >= 0");
        }
        if (pageSize < 1) {
            throw new IllegalArgumentException("pageSize must be > 0");
        }
        return this.errorOccurrenceDao.findErrorOccurrences(pageNo, pageSize, orderBy, orderAscending, moduleName, flowName);
    }

    @Override
    public void logError(Throwable throwable, String moduleName, String initiatorName, String actionTaken) {
        ErrorOccurrence errorOccurrence = new ErrorOccurrence(throwable, moduleName, initiatorName, this.calculateExpiry(), actionTaken);
        this.persistAndNotifyListeners(errorOccurrence);
    }

    @Override
    public ErrorOccurrence getErrorOccurrence(long errorOccurrenceId) {
        ErrorOccurrence errorOccurrence = this.errorOccurrenceDao.getErrorOccurrence(errorOccurrenceId);
        if (errorOccurrence != null) {
            errorOccurrence.setExcludedEvent(this.excludedEventDao.getExcludedEvent(errorOccurrence.getEventId(), false));
        }
        return errorOccurrence;
    }

    @Override
    public void housekeep() {
        this.errorOccurrenceDao.deleteAllExpired();
    }

    public void setErrorTimeToLiveDays(long errorTimeToLiveDays) {
        this.errorTimeToLiveDays = errorTimeToLiveDays;
    }

    @Override
    public List<ErrorOccurrence> getErrorOccurrences(String eventId) {
        return this.errorOccurrenceDao.getErrorOccurrences(eventId);
    }

    @Override
    public void addErrorOccurrenceListener(ErrorOccurrenceListener errorOccurrenceListener) {
        this.errorOccurrenceListeners.add(errorOccurrenceListener);
    }

    @Override
    public void removeErrorOccurrenceListener(ErrorOccurrenceListener errorOccurrenceListener) {
        this.errorOccurrenceListeners.remove(errorOccurrenceListener);
    }
}

