/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.error.model;

import java.util.Date;
import org.ikasan.framework.component.Event;
import org.ikasan.framework.event.exclusion.model.ExcludedEvent;

public class ErrorOccurrence {
    private Long id;
    private String errorDetail;
    private String eventId;
    private String flowElementName;
    private String flowName;
    private String initiatorName;
    private Date logTime;
    private String moduleName;
    private Date expiry;
    private ExcludedEvent excludedEvent;
    private String url;
    private String actionTaken;
    private Event errorEvent;

    private ErrorOccurrence() {
    }

    public ErrorOccurrence(Throwable throwable, Event event, String moduleName, String flowName, String flowElementName, Date expiry, String actionTaken) {
        this(throwable, moduleName, expiry, actionTaken);
        this.flowElementName = flowElementName;
        this.flowName = flowName;
        this.eventId = event.getId();
        this.errorEvent = event;
    }

    public ErrorOccurrence(Throwable throwable, String moduleName, String initiatorName, Date expiry, String actionTaken) {
        this(throwable, moduleName, expiry, actionTaken);
        this.initiatorName = initiatorName;
    }

    private ErrorOccurrence(Throwable throwable, String moduleName, Date expiry, String actionTaken) {
        this.errorDetail = this.flattenThrowable(throwable);
        this.moduleName = moduleName;
        this.logTime = new Date();
        this.expiry = expiry;
        this.actionTaken = actionTaken;
    }

    private String flattenThrowable(Throwable throwable) {
        StringBuffer flattenedBuffer = new StringBuffer();
        for (Throwable cause = throwable; cause != null; cause = cause.getCause()) {
            flattenedBuffer.append(throwable.toString());
            flattenedBuffer.append("\n");
            for (StackTraceElement stackTraceElement : cause.getStackTrace()) {
                flattenedBuffer.append(stackTraceElement.toString());
                flattenedBuffer.append("\n");
            }
            if (cause.getCause() == null) continue;
            flattenedBuffer.append("caused by ...\n");
        }
        return flattenedBuffer.toString();
    }

    public String getErrorDetail() {
        return this.errorDetail;
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getFlowElementName() {
        return this.flowElementName;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public String getInitiatorName() {
        return this.initiatorName;
    }

    public Date getLogTime() {
        return this.logTime;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setErrorDetail(String errorDetail) {
        this.errorDetail = errorDetail;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public void setFlowElementName(String flowElementName) {
        this.flowElementName = flowElementName;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public void setInitiatorName(String initiatorName) {
        this.initiatorName = initiatorName;
    }

    public void setLogTime(Date logTime) {
        this.logTime = logTime;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public Long getId() {
        return this.id;
    }

    public String getErrorSummary() {
        if (this.errorDetail.length() < 100) {
            return this.errorDetail;
        }
        return this.errorDetail.substring(0, 100);
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setExpiry(Date expiry) {
        this.expiry = expiry;
    }

    public Date getExpiry() {
        return this.expiry;
    }

    public ExcludedEvent getExcludedEvent() {
        return this.excludedEvent;
    }

    public void setExcludedEvent(ExcludedEvent excludedEvent) {
        this.excludedEvent = excludedEvent;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public String getActionTaken() {
        return this.actionTaken;
    }

    public void setActionTaken(String actionTaken) {
        this.actionTaken = actionTaken;
    }

    public Event getErrorEvent() {
        return this.errorEvent;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName() + " [");
        sb.append("id=");
        sb.append(this.id);
        sb.append(",");
        sb.append("moduleName=");
        sb.append(this.moduleName);
        sb.append(",");
        sb.append("flowName=");
        sb.append(this.flowName);
        sb.append(",");
        sb.append("initiatorName=");
        sb.append(this.initiatorName);
        sb.append(",");
        sb.append("flowElementName=");
        sb.append(this.flowElementName);
        sb.append(",");
        sb.append("errorDetail=");
        sb.append(this.errorDetail);
        sb.append(",");
        sb.append("eventId=");
        sb.append(this.eventId);
        sb.append(",");
        sb.append("logTime=");
        sb.append(this.logTime);
        sb.append(",");
        sb.append("expiry=");
        sb.append(this.expiry);
        sb.append(",");
        sb.append("url=");
        sb.append(this.url);
        sb.append(",");
        sb.append("actionTaken=");
        sb.append(this.actionTaken);
        sb.append(",");
        sb.append("excludedEvent=");
        sb.append(this.excludedEvent);
        sb.append(",");
        sb.append("errorEvent=");
        sb.append(this.errorEvent);
        sb.append("]");
        return sb.toString();
    }
}

