/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.configuration.service;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;
import org.ikasan.framework.configuration.ConfiguredResource;
import org.ikasan.framework.configuration.dao.ConfigurationDao;
import org.ikasan.framework.configuration.model.Configuration;
import org.ikasan.framework.configuration.model.ConfigurationParameter;
import org.ikasan.framework.configuration.service.ConfigurationException;
import org.ikasan.framework.configuration.service.ConfigurationManagement;
import org.ikasan.framework.configuration.service.ConfigurationService;

public class ConfiguredResourceConfigurationService
implements ConfigurationService<ConfiguredResource, Configuration>,
ConfigurationManagement<ConfiguredResource, Configuration> {
    private static Logger logger = Logger.getLogger(ConfiguredResourceConfigurationService.class);
    private ConfigurationDao staticConfigurationDao;
    private ConfigurationDao dynamicConfigurationDao;

    public ConfiguredResourceConfigurationService(ConfigurationDao staticConfigurationDao, ConfigurationDao dynamicConfigurationDao) {
        this.staticConfigurationDao = staticConfigurationDao;
        if (staticConfigurationDao == null) {
            throw new IllegalArgumentException("configurationDao cannot be 'null'");
        }
        this.dynamicConfigurationDao = dynamicConfigurationDao;
        if (dynamicConfigurationDao == null) {
            throw new IllegalArgumentException("dynamicConfigurationDao cannot be 'null'");
        }
    }

    @Override
    public void configure(ConfiguredResource configuredResource) {
        Configuration configuration = this.staticConfigurationDao.findById(configuredResource.getConfiguredResourceId());
        if (configuration == null) {
            throw new ConfigurationException("Failed to configure configuredResource [" + configuredResource.getConfiguredResourceId() + "]. Configuration not found!");
        }
        Object configurationObject = configuredResource.getConfiguration();
        if (configurationObject != null) {
            try {
                for (ConfigurationParameter configurationParameter : configuration.getConfigurationParameters()) {
                    BeanUtils.setProperty(configurationObject, (String)configurationParameter.getName(), (Object)configurationParameter.getValue());
                }
                configuredResource.setConfiguration(configurationObject);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException(e);
            }
            catch (InvocationTargetException e) {
                throw new ConfigurationException(e);
            }
            catch (RuntimeException e) {
                throw new ConfigurationException("Failed configuration for configuredResource [" + configuredResource.getConfiguredResourceId() + "] " + e.getMessage(), e);
            }
        } else {
            logger.warn((Object)("Cannot configure configuredResource [" + configuredResource.getConfiguredResourceId() + "] as getConfiguration() returned 'null'"));
        }
    }

    @Override
    public Configuration createConfiguration(ConfiguredResource configuredResource) {
        Object configuredObject = configuredResource.getConfiguration();
        if (configuredObject == null) {
            throw new RuntimeException("ConfiguredResource id [" + configuredResource.getConfiguredResourceId() + "] returned a 'null' configuration instance. ");
        }
        Configuration configuration = new Configuration(configuredResource.getConfiguredResourceId());
        ArrayList<ConfigurationParameter> configurationParameters = new ArrayList<ConfigurationParameter>();
        configuration.setConfigurationParameters(configurationParameters);
        try {
            Map properties = BeanUtils.describe(configuredObject);
            for (Map.Entry entry : properties.entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                if ("class".equals(name)) continue;
                configurationParameters.add(new ConfigurationParameter(name, value));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return configuration;
    }

    @Override
    public void update(ConfiguredResource configuredResource) {
        boolean configurationUpdated = false;
        Object runtimeConfiguration = configuredResource.getConfiguration();
        Configuration configuration = this.dynamicConfigurationDao.findById(configuredResource.getConfiguredResourceId());
        for (ConfigurationParameter configurationParameter : configuration.getConfigurationParameters()) {
            String runtimeParameterValue;
            try {
                runtimeParameterValue = BeanUtils.getProperty(runtimeConfiguration, (String)configurationParameter.getName());
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException(e);
            }
            catch (InvocationTargetException e) {
                throw new ConfigurationException(e);
            }
            catch (NoSuchMethodException e) {
                throw new ConfigurationException(e);
            }
            if ((runtimeParameterValue != null || configurationParameter.getValue() == null) && (runtimeParameterValue == null || runtimeParameterValue.equals(configurationParameter.getValue()))) continue;
            configurationUpdated = true;
            configurationParameter.setValue(runtimeParameterValue);
        }
        if (configurationUpdated) {
            this.dynamicConfigurationDao.save(configuration);
        }
    }

    @Override
    public void deleteConfiguration(Configuration configuration) {
        this.staticConfigurationDao.delete(configuration);
    }

    @Override
    public void saveConfiguration(Configuration configuration) {
        this.staticConfigurationDao.save(configuration);
    }

    @Override
    public Configuration getConfiguration(ConfiguredResource configuredResource) {
        return this.staticConfigurationDao.findById(configuredResource.getConfiguredResourceId());
    }
}

