/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.configuration.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.ikasan.framework.configuration.model.ConfigurationParameter;

public class Configuration
implements Serializable {
    protected String configurationId;
    protected String description;
    protected List<ConfigurationParameter> configurationParameters;

    public Configuration(String configurationId) {
        this(configurationId, null, new ArrayList<ConfigurationParameter>());
    }

    public Configuration(String configurationId, List<ConfigurationParameter> configurationParameters) {
        this(configurationId, null, configurationParameters);
    }

    public Configuration(String configurationId, String description, List<ConfigurationParameter> configurationParameters) {
        this.configurationId = configurationId;
        if (configurationId == null) {
            throw new IllegalArgumentException("configurationId cannot be 'null'");
        }
        this.description = description;
        this.configurationParameters = configurationParameters;
        if (configurationParameters == null) {
            throw new IllegalArgumentException("configurationParameters cannot be 'null'");
        }
    }

    protected Configuration() {
    }

    protected void setConfigurationId(String configurationId) {
        this.configurationId = configurationId;
    }

    public String getConfigurationId() {
        return this.configurationId;
    }

    public List<ConfigurationParameter> getConfigurationParameters() {
        return this.configurationParameters;
    }

    public void setConfigurationParameters(List<ConfigurationParameter> configurationParameters) {
        this.configurationParameters = configurationParameters;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Configuration)) {
            return false;
        }
        Configuration configuration = (Configuration)object;
        return this.configurationId.equals(configuration.configurationId) && this.equalsOrNull(this.description, configuration.description) && this.configurationParameters.size() == configuration.configurationParameters.size() && this.configurationParameters.containsAll(configuration.configurationParameters);
    }

    private boolean equalsOrNull(Object object1, Object object2) {
        if (object1 != null && object1.equals(object2)) {
            return true;
        }
        return object1 == null && object2 == null;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + this.configurationId.hashCode();
        hash = hash * 31 + (this.description == null ? 0 : this.description.hashCode());
        for (ConfigurationParameter configurationParameter : this.configurationParameters) {
            hash = hash * 31 + (configurationParameter == null ? 0 : configurationParameter.hashCode());
        }
        return hash;
    }
}

