/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.component.transformation.xslt.util;

import java.io.ByteArrayOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XsltUtils {
    private static final Logger logger = Logger.getLogger(XsltUtils.class);

    public static String serialize(NodeList nodeset) throws TransformerFactoryConfigurationError, TransformerException {
        Transformer serializer = TransformerFactory.newInstance().newTransformer();
        serializer.setOutputProperty("omit-xml-declaration", "yes");
        serializer.setOutputProperty("indent", "yes");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        for (int i = 0; i < nodeset.getLength(); ++i) {
            Node node = nodeset.item(i);
            if (node == null) continue;
            serializer.transform(new DOMSource(node), new StreamResult(outputStream));
        }
        String serializedXml = new String(outputStream.toByteArray());
        logger.debug((Object)("Serialized xml = [" + serializedXml + "]."));
        return serializedXml;
    }
}

