/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.component.transformation.xslt.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.ikasan.framework.component.transformation.ThreadLocalBeansWrapper;

public class TransformationDataLookup {
    public static final String DEFAULT_DELIMITER = "#";
    private static final Logger logger = Logger.getLogger(TransformationDataLookup.class);

    public static String lookupData(String beanName, String methodName, String args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return TransformationDataLookup.lookupData(beanName, methodName, args, DEFAULT_DELIMITER);
    }

    public static String lookupData(String beanName, String methodName, String args, String delimiter) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return TransformationDataLookup.lookupData(beanName, methodName, TransformationDataLookup.getStringArgs(args, delimiter));
    }

    public static String lookupData(String beanName, String methodName, String ... stringArgs) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String result = null;
        Object bean = TransformationDataLookup.getBean(beanName);
        if (bean == null) {
            throw new IllegalStateException("beanName [" + beanName + "] must be in beans map for this thread prior to execution");
        }
        Method beanMethod = TransformationDataLookup.getBeanMethod(bean, methodName, stringArgs.length);
        logger.info((Object)("about to invoke method of name [" + methodName + "] on bean [" + beanName + "]"));
        result = (String)beanMethod.invoke(bean, (Object[])stringArgs);
        return result;
    }

    private static Method getBeanMethod(Object bean, String methodName, int noOfStringArguments) throws NoSuchMethodException {
        Class[] types = new Class[noOfStringArguments];
        for (int i = 0; i < types.length; ++i) {
            types[i] = String.class;
        }
        Method beanMethod = bean.getClass().getDeclaredMethod(methodName, types);
        return beanMethod;
    }

    private static String[] getStringArgs(String args, String delimiter) {
        StringTokenizer st = new StringTokenizer(args, delimiter);
        ArrayList<String> arguments = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            arguments.add(st.nextToken());
        }
        return arguments.toArray(new String[0]);
    }

    protected static Object getBean(String beanName) {
        return ThreadLocalBeansWrapper.getBeans().get(beanName);
    }
}

