/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.component.transformation.flatfile.reader;

import java.util.List;
import java.util.StringTokenizer;
import org.ikasan.framework.component.transformation.flatfile.reader.BaseStringHandlingFlatFileReader;
import org.ikasan.framework.component.transformation.flatfile.reader.field.BaseFieldDefinition;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SimpleDelimitedFlatFileReader
extends BaseStringHandlingFlatFileReader {
    private static final String DEFAULT_DELIMITER = ",";
    private String delimiter = ",";
    private List<BaseFieldDefinition> fieldDefinitions;

    public SimpleDelimitedFlatFileReader(String rootElementName, List<BaseFieldDefinition> fieldDefinitions, boolean trimTrailingWhitespace) {
        super(rootElementName, trimTrailingWhitespace);
        this.fieldDefinitions = fieldDefinitions;
    }

    @Override
    protected void parseString(String string) throws SAXException {
        StringTokenizer st = new StringTokenizer(string, this.delimiter);
        for (BaseFieldDefinition fieldDefinition : this.fieldDefinitions) {
            if (!st.hasMoreTokens()) {
                if (fieldDefinition.isOptionalField()) break;
                throw new SAXParseException("no more content exists to satisfy field [" + fieldDefinition.getFieldName() + "]", null);
            }
            this.reportField(fieldDefinition, st.nextToken());
        }
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

