/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.component.transformation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.ikasan.common.Payload;
import org.ikasan.framework.component.Event;
import org.ikasan.framework.component.transformation.ExceptionThrowingErrorListener;
import org.ikasan.framework.component.transformation.ThreadLocalBeansWrapper;
import org.ikasan.framework.component.transformation.TransformationException;
import org.ikasan.framework.component.transformation.Transformer;
import org.ikasan.framework.component.transformation.configuration.XsltConfiguration;
import org.ikasan.framework.configuration.ConfiguredResource;
import org.ikasan.framework.flow.ManagedResource;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XsltTransformer
implements Transformer,
ManagedResource,
ConfiguredResource<XsltConfiguration> {
    private static final String CLASSPATH_URL_PREFIX = "classpath:";
    private XsltConfiguration configuration;
    private String configuredResourceId;
    private XMLReader xmlReader;
    private Templates templates;
    private TransformerFactory transformerFactory;
    private ErrorListener errorListener = new ExceptionThrowingErrorListener();
    private Map<String, String> transformationParameters;
    private Map<String, Object> externalResources;
    private String payloadName;
    private URIResolver uriResolver;

    public XsltTransformer(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
        if (this.transformerFactory == null) {
            throw new IllegalArgumentException("The TransformerFactory cannot be null.");
        }
        this.transformerFactory.setErrorListener(this.errorListener);
    }

    public String getPayloadName() {
        return this.payloadName;
    }

    public void setPayloadName(String payloadName) {
        this.payloadName = payloadName;
    }

    public void setURIResolver(URIResolver resolver) {
        this.uriResolver = resolver;
    }

    public XMLReader getXmlReader() {
        return this.xmlReader;
    }

    public void setXmlReader(XMLReader xmlReader) {
        this.xmlReader = xmlReader;
    }

    public Map<String, String> getTransformationParameters() {
        return this.transformationParameters;
    }

    public void setTransformationParameters(Map<String, String> transformationParameters) {
        this.transformationParameters = transformationParameters;
    }

    public Map<String, Object> getExternalResources() {
        return this.externalResources;
    }

    public void setExternalResources(Map<String, Object> externalResources) {
        this.externalResources = externalResources;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    @Override
    public String getConfiguredResourceId() {
        return this.configuredResourceId;
    }

    @Override
    public void setConfiguredResourceId(String id) {
        this.configuredResourceId = id;
    }

    @Override
    public XsltConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(XsltConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void onEvent(Event event) throws TransformationException {
        List<Payload> payloads = event.getPayloads();
        for (Payload payload : payloads) {
            try {
                this.transform(payload);
            }
            catch (TransformerException e) {
                throw new TransformationException(e);
            }
            finally {
                ThreadLocalBeansWrapper.remove();
            }
        }
    }

    private javax.xml.transform.Transformer createNewConfiguredTransformer() throws TransformerConfigurationException {
        javax.xml.transform.Transformer transformer = null;
        if (this.templates != null) {
            transformer = this.templates.newTransformer();
        } else {
            StreamSource streamSource = new StreamSource(this.configuration.getStylesheetLocation());
            transformer = this.transformerFactory.newTransformer(streamSource);
        }
        this.configureTransformer(transformer);
        return transformer;
    }

    private void configureTransformer(javax.xml.transform.Transformer transformer) {
        transformer.setErrorListener(this.errorListener);
        this.setPayloadParameters(transformer);
        this.addTransformationParameters(transformer, this.transformationParameters);
        if (this.uriResolver != null) {
            transformer.setURIResolver(this.uriResolver);
        }
    }

    protected void setPayloadParameters(javax.xml.transform.Transformer transformer) {
        HashMap<String, String> payloadTransformationParamters = new HashMap<String, String>();
        this.addTransformationParameters(transformer, payloadTransformationParamters);
    }

    private void addTransformationParameters(javax.xml.transform.Transformer transformer, Map<String, String> parameters) {
        if (parameters != null) {
            for (String parameterName : parameters.keySet()) {
                transformer.setParameter(parameterName, parameters.get(parameterName));
            }
        }
    }

    protected void transform(Payload payload) throws TransformerException {
        ThreadLocalBeansWrapper.setBeans(this.externalResources);
        Source sourceXml = this.createSourceXml(payload);
        ByteArrayOutputStream transformedDataStream = new ByteArrayOutputStream();
        javax.xml.transform.Transformer transformer = this.createNewConfiguredTransformer();
        transformer.transform(sourceXml, new StreamResult(transformedDataStream));
        byte[] transformedData = transformedDataStream.toByteArray();
        payload.setContent(transformedData);
    }

    private Source createSourceXml(Payload payload) {
        ByteArrayInputStream untransformedDataStream = new ByteArrayInputStream(payload.getContent());
        InputSource inputSource = new InputSource(untransformedDataStream);
        SAXSource source = null;
        source = this.xmlReader == null ? new SAXSource(inputSource) : new SAXSource(this.xmlReader, inputSource);
        return source;
    }

    @Override
    public void startManagedResource() {
        if (this.configuration.isUseTranslets()) {
            try {
                this.templates = this.transformerFactory.newTemplates(this.createTransformationInstructions());
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Source createTransformationInstructions() {
        StreamSource xsltSource = null;
        String xslLocation = this.configuration.getStylesheetLocation();
        if (xslLocation.startsWith(CLASSPATH_URL_PREFIX)) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            InputStream xslIS = classLoader.getResourceAsStream(this.stripClasspathScheme(xslLocation));
            xsltSource = new StreamSource(xslIS);
        } else {
            xsltSource = new StreamSource(xslLocation);
        }
        return xsltSource;
    }

    @Override
    public void stopManagedResource() {
        this.templates = null;
    }

    private String stripClasspathScheme(String xslLocation) {
        int index = xslLocation.indexOf(CLASSPATH_URL_PREFIX) + CLASSPATH_URL_PREFIX.length();
        return xslLocation.substring(index);
    }
}

