/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.component.transformation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.List;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.ikasan.common.Payload;
import org.ikasan.framework.component.Event;
import org.ikasan.framework.component.transformation.ExceptionThrowingErrorListener;
import org.ikasan.framework.component.transformation.TransformationException;
import org.ikasan.framework.component.transformation.Transformer;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XMLReaderTransformer
implements Transformer {
    private XMLReader xmlReader;
    private TransformerFactory transformerFactory;
    private ErrorListener exceptionThrowingErrorListener = new ExceptionThrowingErrorListener();
    private static final Logger logger = Logger.getLogger(XMLReaderTransformer.class);

    public XMLReaderTransformer(TransformerFactory transformerFactory, XMLReader xmlReader) {
        this.transformerFactory = transformerFactory;
        if (this.transformerFactory == null) {
            throw new IllegalArgumentException("transformerFactory cannot be 'null'");
        }
        this.xmlReader = xmlReader;
        if (this.xmlReader == null) {
            throw new IllegalArgumentException("xmlReader cannot be 'null'");
        }
    }

    @Override
    public void onEvent(Event event) throws TransformationException {
        List<Payload> payloads = event.getPayloads();
        for (Payload payload : payloads) {
            ByteArrayInputStream untransformedDataStream = new ByteArrayInputStream(payload.getContent());
            ByteArrayOutputStream transformedDataStream = new ByteArrayOutputStream();
            try {
                InputSource inputSource = new InputSource(untransformedDataStream);
                SAXSource saxSource = new SAXSource(this.xmlReader, inputSource);
                javax.xml.transform.Transformer transformer = this.transformerFactory.newTransformer();
                transformer.setErrorListener(this.exceptionThrowingErrorListener);
                transformer.transform(saxSource, new StreamResult(transformedDataStream));
            }
            catch (TransformerException e) {
                throw new TransformationException(e);
            }
            byte[] transformedData = transformedDataStream.toByteArray();
            logger.debug((Object)("setting payload content [" + new String(transformedData) + "]"));
            payload.setContent(transformedData);
            logger.debug((Object)new String(transformedData));
        }
    }
}

