/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.component.transformation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;
import org.ikasan.common.Payload;
import org.ikasan.framework.component.Event;
import org.ikasan.framework.component.transformation.TransformationException;
import org.ikasan.framework.component.transformation.Transformer;

public class UncompressDataTransformer
implements Transformer {
    private static final Logger logger = Logger.getLogger(UncompressDataTransformer.class);
    protected static final int END_OF_FILE = -1;

    @Override
    public void onEvent(Event event) throws TransformationException {
        ByteArrayOutputStream uncompressedContent = null;
        GZIPInputStream gzipReader = null;
        ByteArrayInputStream compressedContent = null;
        int bytesRead = 0;
        for (Payload payload : event.getPayloads()) {
            uncompressedContent = null;
            gzipReader = null;
            compressedContent = new ByteArrayInputStream(payload.getContent());
            try {
                gzipReader = new GZIPInputStream(compressedContent);
                uncompressedContent = new ByteArrayOutputStream();
                bytesRead = 0;
                while ((bytesRead = gzipReader.read()) != -1) {
                    uncompressedContent.write(bytesRead);
                }
                payload.setContent(uncompressedContent.toByteArray());
            }
            catch (IOException e) {
                throw new TransformationException(e);
            }
            finally {
                try {
                    if (gzipReader != null) {
                        gzipReader.close();
                    }
                    if (uncompressedContent != null) {
                        uncompressedContent.close();
                    }
                    ((InputStream)compressedContent).close();
                }
                catch (IOException e) {
                    logger.warn((Object)"Could not close streams properly.");
                    throw new TransformationException(e);
                }
            }
        }
    }
}

