/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.component.transformation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.ikasan.common.Payload;
import org.ikasan.framework.component.Event;
import org.ikasan.framework.component.transformation.ExceptionThrowingErrorListener;
import org.ikasan.framework.component.transformation.ThreadLocalBeansWrapper;
import org.ikasan.framework.component.transformation.TransformationException;
import org.ikasan.framework.component.transformation.Transformer;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class ExtendedXsltTransformer
implements Transformer {
    private XMLReader xmlReader;
    private Templates templates;
    private URI styleSheetUri;
    private TransformerFactory transformerFactory;
    private Map<String, Object> externalDataBeans;
    private ErrorListener exceptionThrowingErrorListener = new ExceptionThrowingErrorListener();
    private Map<String, String> transformationParameters;
    private static final Logger logger = Logger.getLogger(ExtendedXsltTransformer.class);

    public ExtendedXsltTransformer(TransformerFactory transformerFactory, URI styleSheetUri, boolean useTranslets, Map<String, Object> externalDataBeans, Map<String, String> transformationParameters, XMLReader xmlReader) throws TransformerConfigurationException {
        transformerFactory.setErrorListener(this.exceptionThrowingErrorListener);
        this.xmlReader = xmlReader;
        this.styleSheetUri = styleSheetUri;
        this.transformerFactory = transformerFactory;
        this.externalDataBeans = externalDataBeans;
        this.transformationParameters = transformationParameters;
        logger.info((Object)("styleSheetUri=[" + styleSheetUri + "]"));
        if (useTranslets) {
            logger.debug((Object)"using translets!");
            StreamSource streamSource = new StreamSource(styleSheetUri.toString());
            this.templates = transformerFactory.newTemplates(streamSource);
        }
    }

    public ExtendedXsltTransformer(TransformerFactory transformerFactory, URI styleSheetUri, boolean useTranslets, Map<String, Object> externalDataBeans, Map<String, String> transformationParameters) throws TransformerConfigurationException {
        this(transformerFactory, styleSheetUri, useTranslets, externalDataBeans, transformationParameters, null);
    }

    @Override
    public void onEvent(Event event) throws TransformationException {
        List<Payload> payloads = event.getPayloads();
        for (Payload payload : payloads) {
            try {
                this.transform(payload);
            }
            catch (TransformerException e) {
                throw new TransformationException(e);
            }
            finally {
                ThreadLocalBeansWrapper.remove();
            }
        }
    }

    private javax.xml.transform.Transformer getTransformer() throws TransformerConfigurationException {
        javax.xml.transform.Transformer transformer = null;
        if (this.templates != null) {
            transformer = this.templates.newTransformer();
        } else {
            StreamSource streamSource = new StreamSource(this.styleSheetUri.toString());
            transformer = this.transformerFactory.newTransformer(streamSource);
        }
        transformer.setErrorListener(this.exceptionThrowingErrorListener);
        this.setPayloadParameters(transformer);
        this.addTransformationParameters(transformer, this.transformationParameters);
        return transformer;
    }

    protected void setPayloadParameters(javax.xml.transform.Transformer transformer) {
        HashMap<String, String> payloadTransformationParamters = new HashMap<String, String>();
        this.addTransformationParameters(transformer, payloadTransformationParamters);
    }

    private void addTransformationParameters(javax.xml.transform.Transformer transformer, Map<String, String> parameters) {
        if (parameters != null) {
            for (String parameterName : parameters.keySet()) {
                transformer.setParameter(parameterName, parameters.get(parameterName));
            }
        }
    }

    protected void addTransformationParameters(Map<String, String> parameters) {
        this.transformationParameters.putAll(parameters);
    }

    protected void transform(Payload payload) throws TransformerException {
        ThreadLocalBeansWrapper.setBeans(this.externalDataBeans);
        ByteArrayInputStream untransformedDataStream = new ByteArrayInputStream(payload.getContent());
        ByteArrayOutputStream transformedDataStream = new ByteArrayOutputStream();
        InputSource inputSource = new InputSource(untransformedDataStream);
        SAXSource saxSource = null;
        saxSource = this.xmlReader == null ? new SAXSource(inputSource) : new SAXSource(this.xmlReader, inputSource);
        javax.xml.transform.Transformer transformer = this.getTransformer();
        transformer.transform(saxSource, new StreamResult(transformedDataStream));
        byte[] transformedData = transformedDataStream.toByteArray();
        logger.debug((Object)("Setting payload content [" + new String(transformedData) + "]"));
        payload.setContent(transformedData);
        logger.debug((Object)new String(transformedData));
    }
}

