/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.component.sequencing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;
import org.ikasan.common.Payload;
import org.ikasan.framework.component.Event;
import org.ikasan.framework.component.sequencing.Sequencer;
import org.ikasan.framework.component.sequencing.SequencerException;

public class UncompressDataSplitter
implements Sequencer {
    private static Logger logger = Logger.getLogger(UncompressDataSplitter.class);
    private static final int END_OF_FILE = -1;

    @Override
    public List<Event> onEvent(Event event, String moduleName, String componentName) throws SequencerException {
        ArrayList<Event> newEvents = new ArrayList<Event>();
        List<Payload> payloads = event.getPayloads();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unzipping event " + event.idToString() + "]."));
        }
        for (Payload payload : payloads) {
            try {
                List<Payload> newPayloads = this.unzipPayload(payload);
                for (int i = 0; i < newPayloads.size(); ++i) {
                    Event newEvent = event.spawnChild(moduleName, componentName, i, newPayloads.get(i));
                    newEvents.add(newEvent);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Incoming event [" + event.getId() + "] split into event [" + newEvent.getId() + "]."));
                }
            }
            catch (CloneNotSupportedException e) {
                throw new SequencerException(e);
            }
            catch (IOException e) {
                throw new SequencerException(e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning [" + newEvents.size() + "] new events."));
            logger.debug((Object)"Splitting event compelted successfully.");
        }
        return newEvents;
    }

    private List<Payload> unzipPayload(Payload payload) throws IOException, CloneNotSupportedException {
        ArrayList<Payload> newPayloads = new ArrayList<Payload>();
        byte[] payloadDataContent = payload.getContent();
        ByteArrayInputStream inputDataInByteArrayFormat = new ByteArrayInputStream(payloadDataContent);
        ZipInputStream inputDataInZippedFormat = new ZipInputStream(inputDataInByteArrayFormat);
        ZipEntry zippedEntry = null;
        int zippedFileCount = 0;
        while ((zippedEntry = inputDataInZippedFormat.getNextEntry()) != null) {
            if (zippedEntry.isDirectory()) {
                logger.debug((Object)("Ignoring directory entry [" + zippedEntry.getName() + "]"));
                continue;
            }
            ByteArrayOutputStream outputDataInByteArrayFormat = new ByteArrayOutputStream();
            int c = inputDataInZippedFormat.read();
            while (c != -1) {
                outputDataInByteArrayFormat.write(c);
                c = inputDataInZippedFormat.read();
            }
            byte[] newPayloadDataContent = outputDataInByteArrayFormat.toByteArray();
            String newPayloadName = zippedEntry.getName().toLowerCase();
            Payload newPayload = payload.spawnChild(zippedFileCount++);
            newPayload.setAttribute("fileName", newPayloadName);
            newPayload.setContent(newPayloadDataContent);
            newPayloads.add(newPayload);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Incomding event's payload [" + payload.getId() + "] split to payload [" + newPayload.getId() + "]."));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning [" + newPayloads.size() + "] new payloads."));
            logger.info((Object)"Splitting payload to its individual unzipped files completed successfully.");
        }
        return newPayloads;
    }
}

