/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.component.sequencing;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.ikasan.common.Payload;
import org.ikasan.framework.component.Event;
import org.ikasan.framework.component.sequencing.Sequencer;
import org.ikasan.framework.component.sequencing.SequencerException;

public class TokenizingSplitter
implements Sequencer {
    private static Logger logger = Logger.getLogger(TokenizingSplitter.class);
    private String delimiterRegex;
    private String encoding;

    public TokenizingSplitter(String delimiterRegex) {
        this(delimiterRegex, null);
    }

    public TokenizingSplitter(String delimiterRegex, String encoding) {
        this.delimiterRegex = delimiterRegex;
        if (this.delimiterRegex == null) {
            throw new IllegalArgumentException("Delimiter expression cannot be 'null'.");
        }
        this.encoding = encoding;
    }

    @Override
    public List<Event> onEvent(Event event, String moduleName, String componentName) throws SequencerException {
        ArrayList<Event> returnedEvents = new ArrayList<Event>();
        String parentId = event.getId();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Splitting event " + event.idToString() + " delimiter expression [" + this.delimiterRegex + "]"));
        }
        for (Payload payload : event.getPayloads()) {
            try {
                List<Payload> newPayloads = this.tokenizeToPayloads(payload);
                for (int i = 0; i < newPayloads.size(); ++i) {
                    Payload newPayload = newPayloads.get(i);
                    Event newEvent = event.spawnChild(moduleName, componentName, i, newPayload);
                    returnedEvents.add(newEvent);
                    if (!logger.isInfoEnabled()) continue;
                    logger.debug((Object)("Incoming event id [" + parentId + "] split to event id [" + newEvent.getId() + "]"));
                }
            }
            catch (CloneNotSupportedException e) {
                throw new SequencerException(e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning [" + returnedEvents.size() + "] new events."));
            logger.debug((Object)"Splitting event based on a token completed successfully.");
        }
        return returnedEvents;
    }

    private List<Payload> tokenizeToPayloads(Payload payload) throws CloneNotSupportedException {
        ArrayList<String> tokens = new ArrayList<String>();
        ArrayList<Payload> newPayloads = new ArrayList<Payload>();
        byte[] data = payload.getContent();
        logger.info((Object)new String(data));
        ByteArrayInputStream bain = new ByteArrayInputStream(data);
        Pattern pattern = Pattern.compile(this.delimiterRegex);
        if (data != null && data.length > 0) {
            Scanner scanner = this.encoding != null && this.encoding.length() > 0 ? new Scanner((InputStream)bain, this.encoding) : new Scanner(bain);
            scanner.useDelimiter(pattern);
            while (scanner.hasNext()) {
                tokens.add(scanner.next());
            }
        }
        if (tokens.size() == 0) {
            if (logger.isDebugEnabled()) {
                logger.info((Object)"No tokens found, returning payload as is.");
            }
            newPayloads.add(payload);
            return newPayloads;
        }
        int tokenCount = 0;
        for (String token : tokens) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating payload for token [" + token + "]"));
            }
            Payload newPayload = payload.spawnChild(tokenCount);
            newPayload.setContent(token.getBytes());
            newPayloads.add(newPayload);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Payload id [" + payload.getId() + "] split to payload id [" + newPayload.getId() + "]"));
            }
            ++tokenCount;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning [" + newPayloads.size() + "] new payloads."));
            logger.debug((Object)"Tokenizing payload completed successfully.");
        }
        return newPayloads;
    }
}

