/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.component.routing;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.ikasan.common.Payload;
import org.ikasan.framework.component.Event;
import org.ikasan.framework.component.routing.Router;
import org.ikasan.framework.component.routing.RouterException;
import org.ikasan.framework.component.routing.UnroutableEventException;
import org.ikasan.framework.component.transformation.ExceptionThrowingErrorHandler;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class XPathBooleanRouter
implements Router {
    private static Logger logger = Logger.getLogger(XPathBooleanRouter.class);
    private DocumentBuilderFactory factory;
    private ErrorHandler errorHandler = new ExceptionThrowingErrorHandler();
    private Map<String, String> xpathExpressionToTransition;
    private boolean returnsDefaultForNonMatches = false;

    public XPathBooleanRouter(DocumentBuilderFactory factory, Map<String, String> xpathExpressionToTransition, boolean returnsDefaultForNonMatches) {
        this.factory = factory;
        if (this.factory == null) {
            throw new IllegalArgumentException("factory cannot be 'null'.");
        }
        this.xpathExpressionToTransition = xpathExpressionToTransition;
        if (this.xpathExpressionToTransition == null || this.xpathExpressionToTransition.isEmpty()) {
            throw new IllegalArgumentException("xpath expression transition map cannot be 'null' or empty.");
        }
        this.returnsDefaultForNonMatches = returnsDefaultForNonMatches;
    }

    public XPathBooleanRouter(DocumentBuilderFactory factory, Map<String, String> xpathExpressionToTransition) {
        this(factory, xpathExpressionToTransition, false);
    }

    @Override
    public List<String> onEvent(Event event) throws RouterException {
        ArrayList<String> xpathResultTransitions = new ArrayList<String>();
        StringBuilder infoMsg = new StringBuilder();
        try {
            List<Payload> payloads = event.getPayloads();
            Payload primaryPayload = payloads.get(0);
            DocumentBuilder builder = this.factory.newDocumentBuilder();
            builder.setErrorHandler(this.errorHandler);
            ByteArrayInputStream payloadContentAsInputStream = new ByteArrayInputStream(primaryPayload.getContent());
            Document document = builder.parse(payloadContentAsInputStream);
            XPath xpathInst = XPathFactory.newInstance().newXPath();
            for (Map.Entry<String, String> pairs : this.xpathExpressionToTransition.entrySet()) {
                String xpathExpression = pairs.getKey();
                Boolean result = (Boolean)xpathInst.evaluate(xpathExpression, document, XPathConstants.BOOLEAN);
                if (result != null && result.equals(Boolean.TRUE)) {
                    xpathResultTransitions.add(pairs.getValue());
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("xpath [" + xpathExpression + "] [" + result + "]. Transition [" + pairs.getValue() + "] added to list."));
                    continue;
                }
                infoMsg.append(" xpath [");
                infoMsg.append(xpathExpression);
                infoMsg.append("] [");
                infoMsg.append(result);
                infoMsg.append("]. Transition [");
                infoMsg.append(pairs.getValue());
                infoMsg.append("] NOT added to list.");
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)infoMsg);
            }
        }
        catch (XPathExpressionException e) {
            throw new RouterException(e);
        }
        catch (SAXException e) {
            throw new RouterException(e);
        }
        catch (IOException e) {
            throw new RouterException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RouterException(e);
        }
        if (xpathResultTransitions.size() < 1) {
            if (this.returnsDefaultForNonMatches) {
                xpathResultTransitions.add("default");
            } else {
                throw new UnroutableEventException("Unable to resolve to a routing transition for event. " + event.idToString() + infoMsg);
            }
        }
        return xpathResultTransitions;
    }
}

