/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.component.endpoint;

import org.ikasan.framework.component.Event;
import org.ikasan.framework.component.endpoint.Endpoint;
import org.ikasan.framework.event.wiretap.service.WiretapService;

public class WiretapEndpoint
implements Endpoint {
    private static final long ONE_WEEK_IN_MILLISECONDS = 604800000L;
    private String moduleName;
    private String flowName;
    private String componentName;
    private WiretapService wiretapService;
    private long wiretapEventTimeToLive = 604800000L;

    public WiretapEndpoint(String moduleName, String flowName, String componentName, WiretapService wiretapService) {
        this.moduleName = moduleName;
        if (this.moduleName == null) {
            throw new IllegalArgumentException("moduleName cannot be 'null'.");
        }
        this.flowName = flowName;
        if (this.flowName == null) {
            throw new IllegalArgumentException("flowName cannot be 'null'.");
        }
        this.componentName = componentName;
        if (this.componentName == null) {
            throw new IllegalArgumentException("componentName cannot be 'null'.");
        }
        this.wiretapService = wiretapService;
        if (this.wiretapService == null) {
            throw new IllegalArgumentException("wiretapService cannot be 'null'.");
        }
    }

    @Override
    public void onEvent(Event event) {
        this.wiretapService.tapEvent(event, this.componentName, this.moduleName, this.flowName, this.wiretapEventTimeToLive);
    }

    public void setWiretapEventTimeToLive(long wiretapEventTimeToLive) {
        if (wiretapEventTimeToLive <= 0L) {
            throw new IllegalArgumentException("wiretapEventTimeToLive must be > 0");
        }
        this.wiretapEventTimeToLive = wiretapEventTimeToLive;
    }
}

