/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.component;

import org.apache.log4j.Logger;
import org.ikasan.framework.component.Event;
import org.ikasan.framework.component.IkasanExceptionHandler;
import org.ikasan.framework.exception.IkasanExceptionAction;
import org.ikasan.framework.exception.StopAction;

public class LoggingExceptionHandlerImpl
implements IkasanExceptionHandler {
    private Logger logger = Logger.getLogger(LoggingExceptionHandlerImpl.class);
    private IkasanExceptionAction rollbackAndStopAction;
    private IkasanExceptionAction errorAction = this.rollbackAndStopAction = StopAction.instance();

    public IkasanExceptionAction invoke(String componentName, Event event, Throwable throwable) {
        this.logger.error((Object)("Throwable caught, componentName [" + componentName + "], event [" + event + "], throwable message[" + throwable.getMessage() + "], stacktrace follows:"));
        this.logErrorThrowable(throwable);
        this.logger.info((Object)(this + " about to return errorAction:" + this.errorAction));
        return this.errorAction;
    }

    private void logErrorThrowable(Throwable throwable) {
        Throwable thisThrowable = throwable;
        while (thisThrowable != null) {
            this.logger.error((Object)throwable.getMessage());
            for (StackTraceElement stackTraceElement : thisThrowable.getStackTrace()) {
                this.logger.error((Object)stackTraceElement);
            }
            if ((thisThrowable = thisThrowable.getCause()) == null) continue;
            this.logger.error((Object)"...caused by...");
        }
    }

    @Override
    public IkasanExceptionAction handleThrowable(String componentName, Throwable throwable) {
        this.logger.error((Object)("Throwable caught, componentName [" + componentName + "], throwable message[" + throwable.getMessage() + "], stacktrace follows:"));
        this.logErrorThrowable(throwable);
        return this.errorAction;
    }

    public void setErrorAction(IkasanExceptionAction errorAction) {
        this.errorAction = errorAction;
    }
}

