/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.component;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.ikasan.common.Payload;

public class Event
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private String id;
    private Date timestamp;
    private int priority = 4;
    private Long persistenceId;
    private List<Payload> payloads = null;

    private Event() {
    }

    private Event(String originatingModuleName, String originatingComponentName, String originatorGeneratedId) {
        if (originatorGeneratedId == null) {
            throw new IllegalArgumentException("Event originator did not provide a generated id!");
        }
        this.id = originatingModuleName + "_" + originatingComponentName + "_" + originatorGeneratedId;
        this.timestamp = new Date();
    }

    public Event(String originatingModuleName, String originatingComponentName, String originatorGeneratedId, List<Payload> payloads) {
        this(originatingModuleName, originatingComponentName, originatorGeneratedId);
        this.payloads = new ArrayList<Payload>(payloads);
    }

    public Event(String originatingModuleName, String originatingComponentName, String originatorGeneratedId, Payload payload) {
        this(originatingModuleName, originatingComponentName, originatorGeneratedId);
        ArrayList<Payload> payloads = new ArrayList<Payload>();
        payloads.add(payload);
        this.payloads = new ArrayList<Payload>(payloads);
    }

    public Event(String id, int priority, Date timestamp, List<Payload> payloads) {
        this.id = id;
        this.priority = priority;
        this.timestamp = timestamp;
        this.payloads = new ArrayList<Payload>(payloads);
    }

    public Event clone() throws CloneNotSupportedException {
        Event clone = (Event)super.clone();
        clone.setTimestamp(this.getTimestamp());
        clone.setPriority(this.priority);
        ArrayList<Payload> clonedPayloads = new ArrayList<Payload>();
        for (Payload payload : this.getPayloads()) {
            clonedPayloads.add(payload.clone());
        }
        clone.payloads = clonedPayloads;
        return clone;
    }

    public String idToString() {
        StringBuffer payloadStringBuffer = new StringBuffer();
        for (Payload payload : this.payloads) {
            payloadStringBuffer.append("Payload [" + payload.getId() + "]");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Event Id [" + this.getId() + "] ");
        sb.append(payloadStringBuffer.toString());
        return sb.toString();
    }

    public String toString() {
        return "id=[" + this.id + "] " + "persistenceId=[" + this.persistenceId + "] " + "priority=[" + this.priority + "] " + "timestamp=[" + this.timestamp + "] " + "payloads=[" + this.payloads + "] " + "class=[" + this.getClass() + "] ";
    }

    public Event spawnChild(String moduleName, String componentName, int siblingNo, List<Payload> payloads) {
        Event event = new Event(moduleName, componentName, "#" + this.getId() + "." + siblingNo, payloads);
        event.setPriority(this.getPriority());
        return event;
    }

    public Event spawnChild(String moduleName, String componentName, int siblingNo, Payload payload) {
        ArrayList<Payload> payloads = new ArrayList<Payload>();
        payloads.add(payload);
        return this.spawnChild(moduleName, componentName, siblingNo, payloads);
    }

    public String getId() {
        return this.id;
    }

    private void setId(String id) {
        this.id = id;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    private void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public String getFormattedTimestamp(DateFormat dateFormat) {
        return dateFormat.format(this.timestamp);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setPayloads(List<Payload> payloadList) {
        this.payloads = payloadList;
    }

    public List<Payload> getPayloads() {
        return this.payloads;
    }

    public Long getPersistenceId() {
        return this.persistenceId;
    }

    private void setPersistenceId(Long persistenceId) {
        this.persistenceId = persistenceId;
    }
}

