/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.json.jackson.modifier;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.ifinalframework.auto.service.annotation.AutoService;
import org.ifinalframework.core.IEnum;
import org.ifinalframework.json.jackson.modifier.AbsSimpleBeanPropertySerializerModifier;

@AutoService(value=BeanSerializerModifier.class)
public class BeanEnumPropertySerializerModifier
extends AbsSimpleBeanPropertySerializerModifier {
    private static final String ENUM_NAME_PROPERTY_SUFFIX = "Name";
    private static final String ENUM_DESC_PROPERTY_SUFFIX = "Desc";

    public JsonSerializer<?> modifyEnumSerializer(SerializationConfig config, JavaType valueType, BeanDescription beanDesc, JsonSerializer<?> serializer) {
        if (IEnum.class.isAssignableFrom(valueType.getRawClass())) {
            return EnumCodeSerializer.instance;
        }
        return super.modifyEnumSerializer(config, valueType, beanDesc, serializer);
    }

    @Override
    protected boolean support(Class<?> clazz) {
        return IEnum.class.isAssignableFrom(clazz);
    }

    @Override
    public Collection<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, BeanPropertyDefinition property, BeanPropertyWriter writer) {
        BeanPropertyWriter enumNamePropertyWriter = this.buildEnumNamePropertyWriter(beanDesc, property, writer);
        BeanPropertyWriter enumDescPropertyWriter = this.buildEnumDescPropertyWriter(beanDesc, property, writer);
        return Arrays.asList(enumNamePropertyWriter, enumDescPropertyWriter);
    }

    private BeanPropertyWriter buildEnumNamePropertyWriter(BeanDescription beanDesc, BeanPropertyDefinition property, BeanPropertyWriter writer) {
        BeanPropertyWriter enumNamePropertyWriter = new BeanPropertyWriter(property, writer.getMember(), beanDesc.getClassAnnotations(), property.getPrimaryType(), (JsonSerializer)EnumNameSerializer.instance, writer.getTypeSerializer(), writer.getSerializationType(), writer.willSuppressNulls(), null, property.findViews());
        this.setNameValue(enumNamePropertyWriter, enumNamePropertyWriter.getName() + ENUM_NAME_PROPERTY_SUFFIX);
        return enumNamePropertyWriter;
    }

    private BeanPropertyWriter buildEnumDescPropertyWriter(BeanDescription beanDesc, BeanPropertyDefinition property, BeanPropertyWriter writer) {
        BeanPropertyWriter enumDescriptionPropertyWriter = new BeanPropertyWriter(property, writer.getMember(), beanDesc.getClassAnnotations(), property.getPrimaryType(), (JsonSerializer)EnumDescSerializer.instance, writer.getTypeSerializer(), writer.getSerializationType(), writer.willSuppressNulls(), null, property.findViews());
        this.setNameValue(enumDescriptionPropertyWriter, enumDescriptionPropertyWriter.getName() + ENUM_DESC_PROPERTY_SUFFIX);
        return enumDescriptionPropertyWriter;
    }

    private static class EnumNameSerializer
    extends JsonSerializer<Enum<?>> {
        public static final EnumNameSerializer instance = new EnumNameSerializer();

        private EnumNameSerializer() {
        }

        public void serialize(Enum<?> value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.name());
        }
    }

    private static class EnumDescSerializer
    extends JsonSerializer<IEnum<?>> {
        public static final EnumDescSerializer instance = new EnumDescSerializer();

        private EnumDescSerializer() {
        }

        public void serialize(IEnum<?> value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.getDesc());
        }
    }

    private static class EnumCodeSerializer
    extends JsonSerializer<IEnum> {
        public static final EnumCodeSerializer instance = new EnumCodeSerializer();

        private EnumCodeSerializer() {
        }

        public void serialize(IEnum value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeObject(value.getCode());
        }
    }
}

