/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.json.jackson.modifier;

import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ifinalframework.json.jackson.modifier.BeanPropertySerializerModifier;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

public abstract class AbsBeanPropertySerializerModifier
extends BeanSerializerModifier
implements BeanPropertySerializerModifier {
    private static final Field NAME_FIELD = Objects.requireNonNull(ReflectionUtils.findField(BeanPropertyWriter.class, (String)"_name"));

    protected void setNameValue(BeanPropertyWriter bpw, String value) {
        ReflectionUtils.setField((Field)NAME_FIELD, (Object)bpw, (Object)new SerializedString(value));
    }

    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        Map beanPropertyWriterMap = beanProperties.stream().collect(Collectors.toMap(BeanPropertyWriter::getName, Function.identity()));
        List properties = beanDesc.findProperties();
        for (BeanPropertyDefinition property : properties) {
            BeanPropertyWriter def;
            Collection changeProperties;
            if (!this.support(property) || CollectionUtils.isEmpty((Collection)(changeProperties = this.changeProperties(config, beanDesc, property, def = (BeanPropertyWriter)beanPropertyWriterMap.get(property.getName()))))) continue;
            int index = beanProperties.indexOf(def);
            if (index != -1) {
                beanProperties.addAll(index + 1, changeProperties);
                continue;
            }
            beanProperties.addAll(changeProperties);
        }
        return super.changeProperties(config, beanDesc, beanProperties);
    }

    static {
        ReflectionUtils.makeAccessible((Field)NAME_FIELD);
    }
}

