/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.json.jackson.initializer;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.time.LocalDateTime;
import java.util.ServiceLoader;
import org.ifinalframework.auto.service.annotation.AutoService;
import org.ifinalframework.json.jackson.FinalJacksonModule;
import org.ifinalframework.json.jackson.ObjectMapperInitializer;
import org.ifinalframework.json.jackson.deserializer.LocalDateTimeDeserializer;
import org.ifinalframework.json.jackson.serializer.LocalDateTimeSerializer;
import org.springframework.lang.NonNull;

@AutoService(value=ObjectMapperInitializer.class)
public class ModuleObjectMapperInitializer
implements ObjectMapperInitializer {
    @Override
    public void initialize(@NonNull ObjectMapper objectMapper) {
        objectMapper.registerModule((Module)new Jdk8Module());
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer((JsonSerializer)new LocalDateTimeSerializer());
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer());
        objectMapper.registerModule((Module)javaTimeModule);
        objectMapper.registerModule((Module)new FinalJacksonModule());
        ServiceLoader.load(Module.class, objectMapper.getClass().getClassLoader()).forEach(arg_0 -> ((ObjectMapper)objectMapper).registerModule(arg_0));
    }
}

