/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.json.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.ServiceLoader;
import org.ifinalframework.json.jackson.ObjectMapperInitializer;

public class ObjectMapperFactory {
    private final ObjectMapper objectMapper;

    public ObjectMapperFactory() {
        this(new ObjectMapper());
    }

    public ObjectMapperFactory(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        ServiceLoader.load(ObjectMapperInitializer.class, this.getClass().getClassLoader()).forEach(it -> it.initialize(this.objectMapper));
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public ObjectMapper create() {
        return this.objectMapper;
    }
}

