/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.json;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.ifinalframework.json.JsonException;
import org.ifinalframework.json.JsonRegistry;
import org.ifinalframework.json.TypeReference;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public final class Json {
    private Json() {
        throw new AssertionError((Object)"No Json instances for you!");
    }

    public static String toJson(@Nullable Object object) {
        return Json.toJson(object, null);
    }

    public static String toJson(@Nullable Object object, @Nullable Class<?> view) {
        if (object instanceof String) {
            return ((String)object).trim();
        }
        return Json.wrap(() -> JsonRegistry.getInstance().getJsonService().toJson(object, view));
    }

    public static Object toObject(@Nullable String json) {
        return Json.toObject(json, Object.class);
    }

    public static <T> T toObject(@Nullable String json, @NonNull Class<T> classOfT) {
        return Json.toObject(json, classOfT, null);
    }

    public static <T> T toObject(@Nullable String json, @NonNull Class<T> classOfT, @Nullable Class<?> view) {
        if (String.class.equals(classOfT)) {
            return (T)json;
        }
        return (T)Json.wrap(() -> JsonRegistry.getInstance().getJsonService().toObject(json, classOfT, view));
    }

    public static <T> T toObject(@NonNull String json, @NonNull TypeReference<T> typeOfT) {
        return Json.toObject(json, typeOfT.getType());
    }

    public static <T> T toObject(@NonNull String json, @NonNull Type typeOfT) {
        return Json.toObject(json, typeOfT, null);
    }

    public static <T> T toObject(@NonNull String json, @NonNull TypeReference<T> typeOfT, @Nullable Class<?> view) {
        return Json.toObject(json, typeOfT.getType(), view);
    }

    public static <T> T toObject(@NonNull String json, @NonNull Type typeOfT, @Nullable Class<?> view) {
        if (String.class.equals((Object)typeOfT)) {
            return (T)json;
        }
        return (T)Json.wrap(() -> JsonRegistry.getInstance().getJsonService().toObject(json, typeOfT, view));
    }

    public static <E> List<E> toList(@Nullable String json, @NonNull Class<E> classOfT) {
        return Json.toList(json, classOfT, null);
    }

    public static <E> List<E> toList(@Nullable String json, @NonNull Class<E> classOfT, @Nullable Class<?> view) {
        return Json.wrap(() -> JsonRegistry.getInstance().getJsonService().toList(json, classOfT, view));
    }

    public static <E> Set<E> toSet(@Nullable String json, @NonNull Class<E> classOfT) {
        return Json.toSet(json, classOfT, null);
    }

    public static <E> Set<E> toSet(@Nullable String json, @NonNull Class<E> classOfT, @Nullable Class<?> view) {
        return Json.wrap(() -> JsonRegistry.getInstance().getJsonService().toSet(json, classOfT, view));
    }

    private static <T> T wrap(Supplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (JsonException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }
}

