/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.context.user;

import org.ifinalframework.context.user.SimpleUserContext;
import org.ifinalframework.context.user.UserContext;
import org.ifinalframework.core.IUser;
import org.springframework.core.NamedInheritableThreadLocal;
import org.springframework.core.NamedThreadLocal;
import org.springframework.lang.Nullable;

public final class UserContextHolder {
    private static final String USER_CONTEXT_NAME = "UserContext";
    private static final ThreadLocal<UserContext<? extends IUser<?>>> USER_CONTEXT_HOLDER = new NamedThreadLocal("UserContext");
    private static final ThreadLocal<UserContext<? extends IUser<?>>> INHERITABLE_USER_CONTEXT_HOLDER = new NamedInheritableThreadLocal("UserContext");
    private static IUser<?> defaultUser;

    private UserContextHolder() {
    }

    public static void reset() {
        USER_CONTEXT_HOLDER.remove();
        INHERITABLE_USER_CONTEXT_HOLDER.remove();
    }

    public static void setUserContext(@Nullable UserContext<? extends IUser<?>> localeContext, boolean inheritable) {
        if (localeContext == null) {
            UserContextHolder.reset();
        } else if (inheritable) {
            INHERITABLE_USER_CONTEXT_HOLDER.set(localeContext);
            USER_CONTEXT_HOLDER.remove();
        } else {
            USER_CONTEXT_HOLDER.set(localeContext);
            INHERITABLE_USER_CONTEXT_HOLDER.remove();
        }
    }

    public static void setUserContext(@Nullable UserContext<? extends IUser<?>> localeContext) {
        UserContextHolder.setUserContext(localeContext, false);
    }

    public static <T extends IUser<?>> void setDefaultUser(@Nullable T user) {
        defaultUser = user;
    }

    @Nullable
    public static <T extends IUser<?>> UserContext<T> getUserContext() {
        UserContext<? extends IUser<?>> userContext = USER_CONTEXT_HOLDER.get();
        if (userContext == null) {
            userContext = INHERITABLE_USER_CONTEXT_HOLDER.get();
        }
        return userContext;
    }

    public static <T extends IUser<?>> T getUser(@Nullable UserContext<? extends IUser<?>> localeContext) {
        IUser<?> locale;
        if (localeContext != null && (locale = localeContext.getUser()) != null) {
            return (T)locale;
        }
        return (T)defaultUser;
    }

    @Nullable
    public static <T extends IUser<?>> T getUser() {
        return UserContextHolder.getUser(UserContextHolder.getUserContext());
    }

    public static <T extends IUser<?>> void setUser(@Nullable T user, boolean inheritable) {
        UserContext<T> userContext = UserContextHolder.getUserContext();
        if (userContext == null) {
            userContext = new SimpleUserContext<T>(user);
        }
        UserContextHolder.setUserContext(userContext, inheritable);
    }

    public static void setUser(@Nullable IUser<?> user) {
        UserContextHolder.setUser(user, false);
    }

    public static boolean isLogin() {
        return UserContextHolder.getUser() != null;
    }
}

