/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.context.resource;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import java.util.stream.Collectors;
import org.ifinalframework.context.annotation.ResourceValue;
import org.ifinalframework.context.resource.ResourceValueHolder;
import org.springframework.core.annotation.AnnotatedElementUtils;

public final class ResourceValueUtils {
    private ResourceValueUtils() {
    }

    public static Collection<ResourceValueHolder> findAllResourceValueHolders(Object target, Class<?> clazz) {
        ResourceValueHolder valueHolder;
        LinkedList<ResourceValueHolder> holders = new LinkedList<ResourceValueHolder>();
        if (Objects.isNull(clazz)) {
            return holders;
        }
        ResourceValue resourceValue = (ResourceValue)AnnotatedElementUtils.findMergedAnnotation(clazz, ResourceValue.class);
        if (Objects.isNull(resourceValue)) {
            return holders;
        }
        if (Objects.equals(Object.class, clazz)) {
            return holders;
        }
        for (Field field : clazz.getDeclaredFields()) {
            valueHolder = ResourceValueUtils.processElement(target, field, resourceValue);
            if (!Objects.nonNull(valueHolder)) continue;
            holders.add(valueHolder);
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            valueHolder = ResourceValueUtils.processElement(target, accessibleObject, resourceValue);
            if (!Objects.nonNull(valueHolder)) continue;
            holders.add(valueHolder);
        }
        holders.addAll(ResourceValueUtils.findAllResourceValueHolders(target, clazz.getSuperclass()));
        for (AnnotatedElement annotatedElement : clazz.getInterfaces()) {
            holders.addAll(ResourceValueUtils.findAllResourceValueHolders(target, annotatedElement));
        }
        return holders;
    }

    private static ResourceValueHolder processElement(Object target, AnnotatedElement element, ResourceValue resourceValue) {
        ResourceValue annotation = (ResourceValue)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)element, ResourceValue.class);
        if (Objects.isNull(annotation)) {
            return null;
        }
        return new ResourceValueHolder(ResourceValueUtils.key(resourceValue, annotation), target, element);
    }

    private static String key(ResourceValue ... resourceValues) {
        return Arrays.stream(resourceValues).map(ResourceValue::value).filter(it -> !it.isEmpty()).collect(Collectors.joining("."));
    }
}

