/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.context.resource;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import lombok.Generated;
import org.ifinalframework.context.resource.ResourceValueType;
import org.springframework.util.ReflectionUtils;

public final class ResourceValueHolder {
    private final String key;
    private final Object target;
    private final AnnotatedElement element;
    private final ResourceValueType type;
    private final Type valueType;
    private Object value;

    public ResourceValueHolder(String key, Object target, AnnotatedElement element) {
        this.key = key;
        this.target = target;
        this.element = element;
        if (element instanceof Field) {
            this.type = ResourceValueType.FIELD;
            this.valueType = ((Field)element).getType();
            ReflectionUtils.makeAccessible((Field)((Field)element));
        } else if (element instanceof Method) {
            this.type = ResourceValueType.METHOD;
            ReflectionUtils.makeAccessible((Method)((Method)element));
            this.valueType = ((Method)element).getGenericParameterTypes()[0];
        } else {
            throw new IllegalArgumentException("result value only support filed or method. not support the type of " + element);
        }
    }

    public void setValue(Object value) {
        switch (this.type) {
            case FIELD: {
                try {
                    ((Field)this.element).set(this.target, value);
                    break;
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            case METHOD: {
                try {
                    ((Method)this.element).invoke(this.target, value);
                    break;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            default: {
                throw new IllegalArgumentException("");
            }
        }
        this.value = value;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public Object getTarget() {
        return this.target;
    }

    @Generated
    public AnnotatedElement getElement() {
        return this.element;
    }

    @Generated
    public ResourceValueType getType() {
        return this.type;
    }

    @Generated
    public Type getValueType() {
        return this.valueType;
    }

    @Generated
    public Object getValue() {
        return this.value;
    }
}

