/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.context.resource;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.ifinalframework.context.annotation.ResourceValue;
import org.ifinalframework.context.resource.ResourceValueHolder;
import org.ifinalframework.context.resource.ResourceValueManager;
import org.ifinalframework.context.resource.ResourceValueUtils;
import org.ifinalframework.json.Json;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Component
public class BeanFactoryResourceValueManager
implements ResourceValueManager,
ApplicationContextAware {
    private final MultiValueMap<String, ResourceValueHolder> cache = new LinkedMultiValueMap(256);

    public void setApplicationContext(ApplicationContext applicationContext) {
        Arrays.stream(applicationContext.getBeanNamesForAnnotation(ResourceValue.class)).map(arg_0 -> ((ApplicationContext)applicationContext).getBean(arg_0)).forEach(bean -> {
            Class targetClass = AopUtils.getTargetClass((Object)bean);
            for (ResourceValueHolder holder : ResourceValueUtils.findAllResourceValueHolders(bean, targetClass)) {
                this.addResourceValueHolder(holder.getKey(), holder);
            }
        });
    }

    @Override
    public Collection<ResourceValueHolder> getResourceValueHolders(String key) {
        return (Collection)this.cache.get((Object)key);
    }

    @Override
    public void addResourceValueHolder(String key, ResourceValueHolder holder) {
        this.cache.add((Object)key, (Object)holder);
    }

    @Override
    public void setValue(String key, String value) {
        ((List)this.cache.get((Object)key)).forEach(holder -> holder.setValue(Json.toObject((String)value, (Type)holder.getValueType())));
    }
}

