/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.context.expression;

import org.ifinalframework.context.expression.PropertyMapAccessor;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public final class Spel {
    private static final ExpressionParser PARSER = new SpelExpressionParser(new SpelParserConfiguration(true, true));
    private static final MapAccessor MAP_ACCESSOR = new PropertyMapAccessor();
    private static final ParserContext PARSER_CONTEXT = ParserContext.TEMPLATE_EXPRESSION;

    private Spel() {
        throw new IllegalAccessError("Spel is not support new instance for you!");
    }

    private static EvaluationContext wrapContext(Object context) {
        if (context instanceof EvaluationContext) {
            return (EvaluationContext)context;
        }
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext(context);
        evaluationContext.addPropertyAccessor((PropertyAccessor)MAP_ACCESSOR);
        return evaluationContext;
    }

    public static Object getValue(String expression) {
        return Spel.expression(expression, PARSER_CONTEXT).getValue();
    }

    public static Object getValue(String expression, Object context) {
        return Spel.expression(expression, PARSER_CONTEXT).getValue(Spel.wrapContext(context));
    }

    public static <T> T getValue(String expression, Object context, Class<T> type) {
        return (T)Spel.expression(expression, PARSER_CONTEXT).getValue(Spel.wrapContext(context), type);
    }

    public static void setValue(String expression, Object context, Object value) {
        if (context instanceof EvaluationContext) {
            PARSER.parseExpression(expression).setValue((EvaluationContext)context, value);
        } else {
            PARSER.parseExpression(expression).setValue(context, value);
        }
    }

    private static Expression expression(String expression, ParserContext context) {
        return PARSER.parseExpression(expression, context);
    }
}

