/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.context.expression;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import lombok.Generated;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.expression.AnnotatedElementKey;
import org.springframework.core.BridgeMethodResolver;

public class MethodMetadata {
    private final Method method;
    private final Class<?> returnType;
    private final Type genericReturnType;
    private final Class<?> targetClass;
    private final Method targetMethod;
    private final AnnotatedElementKey methodKey;

    public MethodMetadata(Method method, Class<?> targetClass) {
        this.method = BridgeMethodResolver.findBridgedMethod((Method)method);
        this.returnType = method.getReturnType();
        this.genericReturnType = method.getGenericReturnType();
        this.targetClass = targetClass;
        this.targetMethod = !Proxy.isProxyClass(targetClass) ? AopUtils.getMostSpecificMethod((Method)method, targetClass) : this.method;
        this.methodKey = new AnnotatedElementKey((AnnotatedElement)this.targetMethod, targetClass);
    }

    @Generated
    public Method getMethod() {
        return this.method;
    }

    @Generated
    public Class<?> getReturnType() {
        return this.returnType;
    }

    @Generated
    public Type getGenericReturnType() {
        return this.genericReturnType;
    }

    @Generated
    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    @Generated
    public Method getTargetMethod() {
        return this.targetMethod;
    }

    @Generated
    public AnnotatedElementKey getMethodKey() {
        return this.methodKey;
    }
}

