/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.context.exception.result;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ifinalframework.context.exception.UnCatchException;
import org.ifinalframework.context.exception.handler.GlobalExceptionHandler;
import org.ifinalframework.context.exception.result.ResultExceptionHandler;
import org.ifinalframework.core.IException;
import org.ifinalframework.core.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class ResultGlobalResultExceptionHandler
implements GlobalExceptionHandler<Result<?>> {
    private static final Logger logger = LoggerFactory.getLogger(ResultGlobalResultExceptionHandler.class);
    private final List<ResultExceptionHandler<?>> resultExceptionHandlers = new ArrayList();

    public ResultGlobalResultExceptionHandler(ObjectProvider<List<ResultExceptionHandler<?>>> resultExceptionHandlerObjectProvider) {
        this.resultExceptionHandlers.addAll((Collection)resultExceptionHandlerObjectProvider.getIfAvailable());
    }

    @Override
    public Result<?> handle(@NonNull Throwable throwable) {
        if (throwable instanceof IException) {
            IException e = (IException)throwable;
            logger.warn("==> exception: code={},message={}", (Object)e.getCode(), (Object)e.getMessage());
        } else {
            logger.error("==> ", throwable);
        }
        for (ResultExceptionHandler<?> resultExceptionHandler : this.resultExceptionHandlers) {
            if (!resultExceptionHandler.supports(throwable)) continue;
            Result result = (Result)resultExceptionHandler.handle(throwable);
            result.setTrace(MDC.get((String)"trace"));
            result.setTimestamp(Long.valueOf(System.currentTimeMillis()));
            result.setException(throwable.getClass());
            return result;
        }
        throw new UnCatchException(throwable);
    }
}

