/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.context.beans.factory.support;

import java.util.HashSet;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.ApplicationContextException;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.lang.NonNull;

public class SpringFactoryBeanDefinitionRegistryPostProcessor
implements BeanDefinitionRegistryPostProcessor {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(SpringFactoryBeanDefinitionRegistryPostProcessor.class);
    private final Class<?> springFactory;
    private final boolean supportCustom;

    public SpringFactoryBeanDefinitionRegistryPostProcessor(Class<?> springFactory) {
        this(springFactory, false);
    }

    public SpringFactoryBeanDefinitionRegistryPostProcessor(Class<?> springFactory, boolean supportCustom) {
        this.springFactory = springFactory;
        this.supportCustom = supportCustom;
    }

    public void postProcessBeanDefinitionRegistry(@NonNull BeanDefinitionRegistry registry) {
        if (this.supportCustom) {
            HashSet springFactories = new HashSet(SpringFactoriesLoader.loadFactoryNames(this.springFactory, (ClassLoader)registry.getClass().getClassLoader()));
            for (String annotationName : springFactories) {
                try {
                    Class<?> factoryClass = Class.forName(annotationName);
                    this.doPostProcessBeanDefinitionRegistry(factoryClass, registry);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
        } else {
            this.doPostProcessBeanDefinitionRegistry(this.springFactory, registry);
        }
    }

    private void doPostProcessBeanDefinitionRegistry(Class<?> factoryClass, BeanDefinitionRegistry registry) {
        List factories = SpringFactoriesLoader.loadFactoryNames(factoryClass, (ClassLoader)this.getClass().getClassLoader());
        for (String factory : factories) {
            try {
                Class<?> item = Class.forName(factory);
                if (logger.isDebugEnabled()) {
                    logger.debug("register bean definition: {}", (Object)factory);
                }
                BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)new AnnotatedGenericBeanDefinition(item), (BeanDefinitionRegistry)registry);
            }
            catch (ClassNotFoundException e) {
                throw new ApplicationContextException(factory, (Throwable)e);
            }
        }
    }

    public void postProcessBeanFactory(@NonNull ConfigurableListableBeanFactory beanFactory) {
    }
}

