/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.aop.single;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.ifinalframework.aop.AnnotationBuilder;
import org.ifinalframework.aop.AnnotationFinder;
import org.ifinalframework.aop.AnnotationParser;
import org.ifinalframework.aop.AnnotationSource;
import org.ifinalframework.aop.single.SingleAnnotationParser;
import org.springframework.lang.Nullable;

public class SingleAnnotationSource<A extends Annotation, E>
implements AnnotationSource<Collection<E>> {
    private final Map<Object, Collection<E>> cache = new ConcurrentHashMap<Object, Collection<E>>(1024);
    private final AnnotationParser<Collection<E>> parser;

    public SingleAnnotationSource(Class<A> annotationType, AnnotationBuilder<A, E> builder) {
        this(new SingleAnnotationParser<A, E>(annotationType, builder));
    }

    public SingleAnnotationSource(AnnotationFinder<Collection<A>> finder, AnnotationBuilder<A, E> builder) {
        this(new SingleAnnotationParser<A, E>(finder, builder));
    }

    public SingleAnnotationSource(AnnotationParser<Collection<E>> parser) {
        this.parser = parser;
    }

    @Override
    public Collection<E> getAnnotations(Method method, Class<?> targetClass) {
        if (method.getDeclaringClass() == Object.class) {
            return Collections.emptyList();
        }
        Object cacheKey = this.getCacheKey(method, targetClass);
        return this.cache.computeIfAbsent(cacheKey, key -> this.computeAnnotations(method, targetClass));
    }

    private Collection<E> computeAnnotations(Method method, @Nullable Class<?> targetClass) {
        if (this.allowPublicMethodsOnly() && !Modifier.isPublic(method.getModifiers())) {
            return Collections.emptyList();
        }
        ArrayList<E> annotations = new ArrayList<E>();
        annotations.addAll(this.parser.parseAnnotations(targetClass));
        annotations.addAll(this.parser.parseAnnotations(method));
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            annotations.addAll(this.parser.parseAnnotations(parameters[i], i));
        }
        return annotations;
    }

    protected boolean allowPublicMethodsOnly() {
        return false;
    }
}

