/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.aop.single;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.stream.Collectors;
import org.ifinalframework.aop.AnnotationBuilder;
import org.ifinalframework.aop.AnnotationFinder;
import org.ifinalframework.aop.AnnotationParser;
import org.ifinalframework.aop.single.SingleAnnotationFinder;

public class SingleAnnotationParser<A extends Annotation, E>
implements AnnotationParser<Collection<E>> {
    private final AnnotationFinder<Collection<A>> finder;
    private final AnnotationBuilder<A, E> builder;

    public SingleAnnotationParser(Class<A> annotationType, AnnotationBuilder<A, E> builder) {
        this(new SingleAnnotationFinder<A>(annotationType), builder);
    }

    public SingleAnnotationParser(AnnotationFinder<Collection<A>> finder, AnnotationBuilder<A, E> builder) {
        this.finder = finder;
        this.builder = builder;
    }

    @Override
    public Collection<E> parseAnnotations(Class<?> clazz) {
        return this.finder.findAnnotations(clazz).stream().map(annotation -> this.builder.build(clazz, (Annotation)annotation)).collect(Collectors.toList());
    }

    @Override
    public Collection<E> parseAnnotations(Method method) {
        return this.finder.findAnnotations(method).stream().map(annotation -> this.builder.build(method, (Annotation)annotation)).collect(Collectors.toList());
    }

    @Override
    public Collection<E> parseAnnotations(Parameter parameter, Integer index) {
        return this.finder.findAnnotations(parameter).stream().map(annotation -> this.builder.build(parameter, index, (Annotation)annotation)).collect(Collectors.toList());
    }
}

