/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.aop.single;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Set;
import org.ifinalframework.aop.AnnotationFinder;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.NonNull;

public class SingleAnnotationFinder<A extends Annotation>
implements AnnotationFinder<Collection<A>>,
Serializable {
    private static final long serialVersionUID = -2544023527538343148L;
    private final Class<A> ann;
    private final boolean repeatable;

    private SingleAnnotationFinder(Class<A> ann, boolean repeatable) {
        this.ann = ann;
        this.repeatable = repeatable;
    }

    public SingleAnnotationFinder(Class<A> ann) {
        this.ann = ann;
        this.repeatable = ann.getAnnotation(Repeatable.class) != null;
    }

    @Override
    public Collection<A> findAnnotations(@NonNull AnnotatedElement ae) {
        if (this.repeatable) {
            return AnnotatedElementUtils.findMergedRepeatableAnnotations((AnnotatedElement)ae, this.ann);
        }
        Set annotations = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)ae, this.ann);
        if (annotations.size() > 1) {
            return AnnotatedElementUtils.getAllMergedAnnotations((AnnotatedElement)ae, this.ann);
        }
        return annotations;
    }
}

