/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.aop.simple;

import java.util.List;
import java.util.Objects;
import org.ifinalframework.aop.InterceptorHandler;
import org.ifinalframework.aop.InvocationContext;
import org.ifinalframework.aop.MethodInvocationDispatcher;
import org.springframework.lang.NonNull;

public abstract class SimpleMethodInvocationDispatcher<T>
implements MethodInvocationDispatcher<Boolean> {
    private final List<InterceptorHandler<T, Boolean>> handlers;

    protected SimpleMethodInvocationDispatcher(List<InterceptorHandler<T, Boolean>> handlers) {
        this.handlers = handlers;
    }

    @Override
    public Object before(@NonNull InvocationContext context, @NonNull Boolean annotations) {
        for (InterceptorHandler<T, Boolean> handler : this.handlers) {
            T executor;
            Object value = handler.before(executor = this.getExecutor(), context, annotations);
            if (!Objects.nonNull(value)) continue;
            return value;
        }
        return null;
    }

    @Override
    public void afterReturning(@NonNull InvocationContext context, @NonNull Boolean annotations, Object result) {
        for (InterceptorHandler<T, Boolean> handler : this.handlers) {
            T executor = this.getExecutor();
            handler.afterReturning(executor, context, annotations, result);
        }
    }

    @Override
    public void afterThrowing(@NonNull InvocationContext context, @NonNull Boolean annotations, Throwable throwable) {
        for (InterceptorHandler<T, Boolean> handler : this.handlers) {
            T executor = this.getExecutor();
            handler.afterThrowing(executor, context, annotations, throwable);
        }
    }

    @Override
    public void after(@NonNull InvocationContext context, @NonNull Boolean annotations, Object result, Throwable throwable) {
        for (InterceptorHandler<T, Boolean> handler : this.handlers) {
            T executor = this.getExecutor();
            handler.after(executor, context, annotations, result, throwable);
        }
    }

    @NonNull
    protected abstract T getExecutor();
}

