/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.aop.simple;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.ifinalframework.aop.AnnotationSource;
import org.ifinalframework.aop.simple.SimpleAnnotationFinder;

public class SimpleAnnotationSource
implements AnnotationSource<Boolean> {
    private final Map<Object, Boolean> cache = new ConcurrentHashMap<Object, Boolean>(1024);
    private final SimpleAnnotationFinder finder;

    public SimpleAnnotationSource(Collection<Class<? extends Annotation>> annotationTypes) {
        this.finder = new SimpleAnnotationFinder(annotationTypes);
    }

    @Override
    public Boolean getAnnotations(Method method, Class<?> targetClass) {
        Object cacheKey = this.getCacheKey(method, targetClass);
        return this.cache.computeIfAbsent(cacheKey, key -> {
            if (Boolean.TRUE.equals(this.finder.findAnnotations(method))) {
                return true;
            }
            if (Boolean.TRUE.equals(this.finder.findAnnotations(targetClass))) {
                return true;
            }
            for (Parameter parameter : method.getParameters()) {
                if (!Boolean.TRUE.equals(this.finder.findAnnotations(parameter))) continue;
                return true;
            }
            return false;
        });
    }
}

