/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.aop.multi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.ifinalframework.aop.AnnotationSource;

public class MultiAnnotationSource<E>
implements AnnotationSource<Map<Class<? extends Annotation>, Collection<E>>> {
    private final Map<Object, Map<Class<? extends Annotation>, Collection<E>>> cache = new ConcurrentHashMap<Object, Map<Class<? extends Annotation>, Collection<E>>>(1024);
    private final Map<Class<? extends Annotation>, AnnotationSource<Collection<E>>> sourceMap = new LinkedHashMap<Class<? extends Annotation>, AnnotationSource<Collection<E>>>();

    public void addAnnotationSource(Class<? extends Annotation> annotationType, AnnotationSource<Collection<E>> source) {
        this.sourceMap.put(annotationType, source);
    }

    @Override
    public Map<Class<? extends Annotation>, Collection<E>> getAnnotations(Method method, Class<?> targetClass) {
        Object cacheKey = this.getCacheKey(method, targetClass);
        return this.cache.computeIfAbsent(cacheKey, key -> {
            HashMap<Class<? extends Annotation>, Collection<E>> map = new HashMap<Class<? extends Annotation>, Collection<E>>();
            for (Map.Entry<Class<Annotation>, AnnotationSource<Collection<E>>> entry : this.sourceMap.entrySet()) {
                Collection<E> annotations = entry.getValue().getAnnotations(method, targetClass);
                if (Objects.isNull(annotations) || annotations.isEmpty()) continue;
                map.put(entry.getKey(), annotations);
            }
            return map;
        });
    }
}

