/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.aop.multi;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ifinalframework.aop.AnnotationFinder;
import org.ifinalframework.aop.single.SingleAnnotationFinder;
import org.springframework.lang.NonNull;

public class MultiAnnotationFinder
implements AnnotationFinder<Map<Class<? extends Annotation>, Collection<? extends Annotation>>>,
Serializable {
    private static final long serialVersionUID = -8088506337000616189L;
    private final Collection<Class<? extends Annotation>> annotationTypes;
    private final Map<Class<? extends Annotation>, SingleAnnotationFinder<? extends Annotation>> finders = new LinkedHashMap<Class<? extends Annotation>, SingleAnnotationFinder<? extends Annotation>>();

    public MultiAnnotationFinder(Collection<Class<? extends Annotation>> annotationTypes) {
        this.annotationTypes = annotationTypes;
    }

    @Override
    public Map<Class<? extends Annotation>, Collection<? extends Annotation>> findAnnotations(@NonNull AnnotatedElement ae) {
        LinkedHashMap<Class<? extends Annotation>, Collection<? extends Annotation>> map = new LinkedHashMap<Class<? extends Annotation>, Collection<? extends Annotation>>();
        for (Class<? extends Annotation> annotationType : this.annotationTypes) {
            Object annotations = this.getAnnotationFinder(annotationType).findAnnotations(ae);
            if (annotations.isEmpty()) continue;
            map.put(annotationType, (Collection<? extends Annotation>)annotations);
        }
        return map;
    }

    private SingleAnnotationFinder<? extends Annotation> getAnnotationFinder(Class<? extends Annotation> annotationType) {
        return this.finders.computeIfAbsent(annotationType, SingleAnnotationFinder::new);
    }
}

