/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.auto.spring.factory.processor;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.ifinalframework.auto.service.processor.AnnotationMirrors;
import org.ifinalframework.auto.service.processor.AnnotationValues;
import org.ifinalframework.auto.spring.factory.annotation.SpringFactory;
import org.ifinalframework.auto.spring.factory.processor.SpringFactoryFiles;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.StringUtils;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class SpringFactoryProcessor
extends AbstractProcessor {
    private static final String SPRING_FACTORY_VALUE = "value";
    private static final String SPRING_FACTORY_EXTEND = "extend";
    private final SpringFactoryFiles springFactoryFiles = new SpringFactoryFiles();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.generateFactoryFile();
        } else {
            roundEnv.getRootElements().forEach(element -> {
                switch (element.getKind()) {
                    case CLASS: {
                        this.processClassTypeElement((TypeElement)element);
                        break;
                    }
                    case ANNOTATION_TYPE: {
                        this.processAnnotationTypeElement((TypeElement)element);
                        break;
                    }
                    case PACKAGE: {
                        this.processPackageElement((PackageElement)element, roundEnv);
                        break;
                    }
                }
            });
        }
        return false;
    }

    private void generateFactoryFile() {
        Filer filer = this.processingEnv.getFiler();
        try {
            FileObject existingFile = filer.getResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/spring.factories");
            InputStreamResource resource = new InputStreamResource(existingFile.openInputStream());
            Properties properties = PropertiesLoaderUtils.loadProperties((Resource)resource);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String factoryClassName = ((String)entry.getKey()).trim();
                for (String factoryName : StringUtils.commaDelimitedListToStringArray((String)((String)entry.getValue()))) {
                    this.springFactoryFiles.addSpringFactory(factoryClassName, factoryName.trim());
                }
            }
            this.info("Looking for existing resource file at " + existingFile.toUri());
        }
        catch (IOException e) {
            this.info("Resource file did not already exist.");
        }
        if (this.springFactoryFiles.getSpringFactories().isEmpty()) {
            return;
        }
        try {
            FileObject fileObject = filer.createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/spring.factories", new Element[0]);
            this.springFactoryFiles.writeFactoryFile(fileObject.openOutputStream());
            this.info("Create spring.factories :" + this.springFactoryFiles);
        }
        catch (Exception e) {
            this.error("Create spring.factories error :" + this.springFactoryFiles + ",\n" + e.getMessage());
        }
    }

    private void processClassTypeElement(TypeElement element) {
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (annotationMirror.getAnnotationType().toString().equals(SpringFactory.class.getCanonicalName())) {
                this.processClassSpringFactory(element, annotationMirror);
                continue;
            }
            List<? extends AnnotationMirror> mirrors = annotationMirror.getAnnotationType().asElement().getAnnotationMirrors();
            this.processClassAnnotation(element, mirrors);
        }
    }

    private void processClassSpringFactory(TypeElement element, AnnotationMirror annotationMirror) {
        Map annotationValues = AnnotationMirrors.getAnnotationValues((AnnotationMirror)annotationMirror);
        DeclaredType value = (DeclaredType)((AnnotationValue)annotationValues.get(SPRING_FACTORY_VALUE)).getValue();
        this.springFactoryFiles.addSpringFactory((TypeElement)value.asElement(), element);
        AnnotationValue expandValue = (AnnotationValue)annotationValues.get(SPRING_FACTORY_VALUE);
        if (expandValue != null && Boolean.TRUE.equals(expandValue.getValue())) {
            this.addSpringFactory(((TypeElement)value.asElement()).getQualifiedName().toString());
        }
    }

    private void processClassAnnotation(TypeElement element, List<? extends AnnotationMirror> mirrors) {
        for (AnnotationMirror annotationMirror : mirrors) {
            if (!SpringFactory.class.getCanonicalName().equals(annotationMirror.getAnnotationType().toString())) continue;
            Map annotationValues = AnnotationMirrors.getAnnotationValues((AnnotationMirror)annotationMirror);
            TypeElement springFactory = AnnotationValues.getClass((AnnotationValue)((AnnotationValue)annotationValues.get(SPRING_FACTORY_VALUE)));
            boolean extend = annotationValues.containsKey(SPRING_FACTORY_EXTEND) && AnnotationValues.getBoolean((AnnotationValue)((AnnotationValue)annotationValues.get(SPRING_FACTORY_EXTEND)));
            this.springFactoryFiles.addSpringFactory(springFactory, element);
            if (!Boolean.TRUE.equals(extend)) continue;
            this.springFactoryFiles.addSpringFactory(SpringFactory.class.getCanonicalName(), springFactory.getQualifiedName().toString());
        }
    }

    private void processAnnotationTypeElement(TypeElement element) {
        SpringFactory springFactory = element.getAnnotation(SpringFactory.class);
        if (springFactory != null && springFactory.extend()) {
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().toString().equals(SpringFactory.class.getCanonicalName())) continue;
                Map annotationValues = AnnotationMirrors.getAnnotationValues((AnnotationMirror)annotationMirror);
                DeclaredType value = (DeclaredType)((AnnotationValue)annotationValues.get(SPRING_FACTORY_VALUE)).getValue();
                this.addSpringFactory(((TypeElement)value.asElement()).getQualifiedName().toString());
            }
        }
    }

    private void processPackageElement(PackageElement element, RoundEnvironment roundEnv) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (annotationMirror.getAnnotationType().toString().equals(SpringFactory.class.getCanonicalName())) {
                this.processPackageSpringFactory(element, annotationMirror, roundEnv);
                continue;
            }
            if (annotationMirror.getAnnotationType().toString().equals(SpringFactory.SpringFactories.class.getCanonicalName())) {
                this.processPackageSpringFactories(element, annotationMirror, roundEnv);
                continue;
            }
            List<? extends AnnotationMirror> mirrors = annotationMirror.getAnnotationType().asElement().getAnnotationMirrors();
            this.processPackageAnnotation(element, mirrors, roundEnv);
        }
    }

    private void processPackageSpringFactory(PackageElement packageElement, AnnotationMirror springFactory, RoundEnvironment roundEnv) {
        Map annotationValues = AnnotationMirrors.getAnnotationValues((AnnotationMirror)springFactory);
        DeclaredType value = (DeclaredType)((AnnotationValue)annotationValues.get(SPRING_FACTORY_VALUE)).getValue();
        AnnotationValue expandValue = (AnnotationValue)annotationValues.get(SPRING_FACTORY_EXTEND);
        if (expandValue != null && Boolean.TRUE.equals(expandValue.getValue())) {
            this.addSpringFactory(((TypeElement)value.asElement()).getQualifiedName().toString());
        }
        TypeElement annotation = (TypeElement)value.asElement();
        roundEnv.getElementsAnnotatedWith(annotation).stream().filter(it -> this.processingEnv.getElementUtils().getPackageOf((Element)it).getQualifiedName().toString().startsWith(packageElement.getQualifiedName().toString())).forEach(item -> this.springFactoryFiles.addSpringFactory(annotation, (TypeElement)item));
    }

    private void processPackageSpringFactories(PackageElement element, AnnotationMirror annotationMirror, RoundEnvironment roundEnv) {
        AnnotationValue annotationValue = (AnnotationValue)AnnotationMirrors.getAnnotationValues((AnnotationMirror)annotationMirror).get(SPRING_FACTORY_VALUE);
        List springFactories = (List)annotationValue.getValue();
        for (AnnotationMirror springFactory : springFactories) {
            this.processPackageSpringFactory(element, springFactory, roundEnv);
        }
    }

    private void processPackageAnnotation(PackageElement element, List<? extends AnnotationMirror> mirrors, RoundEnvironment roundEnv) {
        for (AnnotationMirror annotationMirror : mirrors) {
            if (annotationMirror.getAnnotationType().toString().equals(SpringFactory.class.getCanonicalName())) {
                this.processPackageSpringFactory(element, annotationMirror, roundEnv);
                continue;
            }
            if (!annotationMirror.getAnnotationType().toString().equals(SpringFactory.SpringFactories.class.getCanonicalName())) continue;
            AnnotationValue annotationValue = (AnnotationValue)AnnotationMirrors.getAnnotationValues((AnnotationMirror)annotationMirror).get(SPRING_FACTORY_VALUE);
            List springFactories = (List)annotationValue.getValue();
            for (AnnotationMirror springFactory : springFactories) {
                this.processPackageSpringFactory(element, springFactory, roundEnv);
            }
        }
    }

    private void addSpringFactory(String instance) {
        this.addSpringFactory(SpringFactory.class.getCanonicalName(), instance);
    }

    private void addSpringFactory(String factory, String instance) {
        this.springFactoryFiles.addSpringFactory(factory, instance);
    }

    private void info(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
    }

    private void error(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
    }
}

