/*
 * Decompiled with CFR 0.152.
 */
package org.idris.rts;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;

public class Prelude {
    private static final List<String> args = new ArrayList<String>();
    private static final Semaphore messageMutex = new Semaphore(1);
    private static final Map<Thread, BlockingQueue<Object>> messages = new HashMap<Thread, BlockingQueue<Object>>();
    private static final Set<Object> feofFiles = new HashSet<Object>();
    private static final Set<Object> errorFiles = new HashSet<Object>();
    private static final Map<Object, Process> processHandles = new HashMap<Object, Process>();

    public static void idris_initArgs(String[] args) {
        Prelude.args.add(System.getProperty("sun.java.command"));
        Prelude.args.addAll(Arrays.asList(args));
    }

    public static int idris_numArgs() {
        return args.size();
    }

    public static String idris_getArg(int num) {
        return args.get(num);
    }

    public static String getenv(String x) {
        return System.getProperty(x);
    }

    public static int setenv(String key, String value, int overwrite) {
        try {
            if (overwrite != 0 && System.getProperty(key) != null) {
                return 0;
            }
            System.setProperty(key, value);
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException ex) {
            return 0;
        }
        return 1;
    }

    public static String getEnvPair(int n) {
        Object[] properties = System.getProperties().entrySet().toArray();
        if (properties.length > n) {
            return properties[n].toString();
        }
        return null;
    }

    public static int unsetenv(String key) {
        try {
            System.clearProperty(key);
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException ex) {
            return 0;
        }
        return 1;
    }

    public static void exit(int exitCode) {
        System.exit(exitCode);
    }

    public static void usleep(int microsecs) {
        try {
            Thread.sleep(microsecs / 1000, microsecs % 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static int idris_time() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    public static void idris_sendMessage(Object from, Object dest, Object message) throws InterruptedException {
        messageMutex.acquire();
        BlockingQueue<Object> messagesForTarget = messages.get((Thread)dest);
        if (messagesForTarget == null) {
            messagesForTarget = new LinkedBlockingQueue<Object>();
            messages.put((Thread)dest, messagesForTarget);
        }
        messagesForTarget.put(message);
        messageMutex.release();
    }

    public static int idris_checkMessages(Object dest) throws InterruptedException {
        messageMutex.acquire();
        BlockingQueue<Object> messagesForTarget = messages.get((Thread)dest);
        messageMutex.release();
        return messagesForTarget == null ? 0 : messagesForTarget.size();
    }

    public static Object idris_recvMessage(Object dest) throws InterruptedException {
        messageMutex.acquire();
        BlockingQueue<Object> messagesForTarget = messages.get((Thread)dest);
        if (messagesForTarget == null) {
            messagesForTarget = new LinkedBlockingQueue<Object>();
            messages.put((Thread)dest, messagesForTarget);
        }
        messageMutex.release();
        return messagesForTarget.take();
    }

    public static void putStr(String str) {
        System.out.print(str);
    }

    public static void putchar(int c) {
        System.out.print((char)c);
    }

    public static int getchar() {
        try {
            return (char)System.in.read();
        }
        catch (IOException ex) {
            errorFiles.add(System.in);
            return -1;
        }
    }

    public static SeekableByteChannel fileOpen(String name, String privs) {
        try {
            OpenOption[] options;
            switch (privs) {
                case "r": {
                    options = new StandardOpenOption[]{StandardOpenOption.READ};
                    break;
                }
                case "r+": {
                    options = new StandardOpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
                    break;
                }
                case "w": {
                    options = new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE};
                    break;
                }
                case "w+": {
                    options = new StandardOpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE};
                    break;
                }
                case "a": {
                    options = new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.APPEND};
                    break;
                }
                case "a+": {
                    options = new StandardOpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.APPEND};
                    break;
                }
                default: {
                    options = new StandardOpenOption[]{};
                }
            }
            return Files.newByteChannel(new File(name).toPath(), options);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static synchronized Object do_popen(String command, String mode) {
        try {
            Process process = Runtime.getRuntime().exec(command);
            if (mode.equals("r")) {
                InputStream stream = process.getInputStream();
                processHandles.put(stream, process);
                return stream;
            }
            OutputStream stream = process.getOutputStream();
            processHandles.put(stream, process);
            return stream;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static synchronized int pclose(Object file) {
        Process process = processHandles.get(file);
        if (process == null) {
            return -1;
        }
        try {
            int result = process.waitFor();
            errorFiles.remove(file);
            feofFiles.remove(file);
            return result;
        }
        catch (InterruptedException ex) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void fileClose(Object file) {
        try {
            Object object = file;
            synchronized (object) {
                ((Closeable)file).close();
                feofFiles.remove(file);
                errorFiles.remove(file);
            }
        }
        catch (IOException ex) {
            errorFiles.add(file);
        }
    }

    public static synchronized int fpoll(Object file) {
        if (file instanceof InputStream) {
            final InputStream stream = (InputStream)file;
            if (!stream.markSupported()) {
                return -1;
            }
            Thread t = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    InputStream inputStream = stream;
                    synchronized (inputStream) {
                        try {
                            stream.mark(1);
                            System.in.read();
                            stream.reset();
                        }
                        catch (IOException ioEx) {
                            errorFiles.add(stream);
                        }
                    }
                }
            };
            try {
                t.join(1000L);
                return errorFiles.contains(stream) ? -1 : 1;
            }
            catch (InterruptedException intEx) {
                return 0;
            }
        }
        if (file instanceof SelectableChannel) {
            try {
                Selector selector = Selector.open();
                ((SelectableChannel)file).register(selector, 1);
                return selector.select(1000L);
            }
            catch (IOException ioEx) {
                errorFiles.add(file);
                return -1;
            }
        }
        return -1;
    }

    public static synchronized void fputStr(Object file, String string) {
        try {
            if (file instanceof PrintStream) {
                ((PrintStream)file).print(string);
            } else if (file instanceof SeekableByteChannel) {
                ((SeekableByteChannel)file).write(ByteBuffer.wrap(string.getBytes()));
            }
        }
        catch (IOException ex) {
            errorFiles.add(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int fgetc(Object file) {
        Object object = file;
        synchronized (object) {
            ReadableByteChannel channel = file instanceof InputStream ? Channels.newChannel((InputStream)file) : (ReadableByteChannel)file;
            ByteBuffer buf = ByteBuffer.allocate(1);
            try {
                int read;
                do {
                    if ((read = channel.read(buf)) >= 0) continue;
                    feofFiles.add(file);
                    return -1;
                } while (read == 0);
                return buf.get(0);
            }
            catch (IOException ex) {
                errorFiles.add(file);
                return -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String idris_readStr(Object file) {
        Object object = file;
        synchronized (object) {
            ReadableByteChannel channel = file instanceof InputStream ? Channels.newChannel((InputStream)file) : (ReadableByteChannel)file;
            ByteBuffer buf = ByteBuffer.allocate(1);
            StringBuilder resultBuilder = new StringBuilder("");
            String delimiter = System.getProperty("line.separator");
            int read = 0;
            try {
                do {
                    buf.rewind();
                    read = channel.read(buf);
                    if (read > 0) {
                        resultBuilder.append(new String(buf.array()));
                        if (resultBuilder.lastIndexOf(delimiter) > -1) {
                            return resultBuilder.toString();
                        }
                    }
                    if (read >= 0) continue;
                    feofFiles.add(file);
                } while (read >= 0);
            }
            catch (IOException ioEx) {
                errorFiles.add(file);
            }
            return resultBuilder.toString();
        }
    }

    public static synchronized int fileEOF(Object file) {
        return feofFiles.contains(file) ? 1 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int fileError(Object file) {
        Object object = file;
        synchronized (object) {
            if (file == System.out) {
                return System.out.checkError() ? 1 : 0;
            }
            return errorFiles.contains(file) ? 1 : 0;
        }
    }

    public static void fflush(Object file) {
        if (file instanceof PrintStream) {
            ((PrintStream)file).flush();
        }
    }

    public static int isNull(Object o) {
        return o == null ? 1 : 0;
    }

    public static int isNullString(String s) {
        return Prelude.isNull(s);
    }

    public static Object malloc(int size) {
        return ByteBuffer.allocate(size);
    }

    public static void idris_memset(Object buf, int offset, Object c, int size) {
        ByteBuffer buffer = (ByteBuffer)buf;
        buffer.rewind();
        buffer.position(offset);
        byte[] init = new byte[size];
        Arrays.fill(init, (Byte)c);
        buffer.put(init, offset, size);
        buffer.rewind();
    }

    public static void free(Object buf) {
        buf = null;
    }

    public static byte idris_peek(Object buf, int offset) {
        ByteBuffer buffer = (ByteBuffer)buf;
        return buffer.get(offset);
    }

    public static void idris_poke(Object buf, int offset, Object data) {
        ByteBuffer buffer = (ByteBuffer)buf;
        buffer.put(offset, (Byte)data);
    }

    public static void idris_memmove(Object dstBuf, Object srcBuf, int dstOffset, int srcOffset, int size) {
        ByteBuffer dst = (ByteBuffer)dstBuf;
        ByteBuffer src = (ByteBuffer)srcBuf;
        byte[] srcData = new byte[size];
        src.rewind();
        src.position(srcOffset);
        src.get(srcData, 0, size);
        src.rewind();
        dst.rewind();
        dst.position(dstOffset);
        dst.put(srcData, 0, size);
        dst.rewind();
    }

    public static void idris_forceGC(Object thread) {
        System.gc();
    }

    public static int idris_eqPtr(Object reference1, Object reference2) {
        return reference1 == reference2 ? 1 : 0;
    }
}

