/*
 * Decompiled with CFR 0.152.
 */
package org.ict4h.atomfeed.client.repository.datasource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import org.ict4h.atomfeed.client.AtomFeedProperties;
import org.ict4h.atomfeed.client.exceptions.AtomFeedClientException;
import org.ict4h.atomfeed.client.repository.datasource.ClientCookies;
import org.ict4h.atomfeed.client.repository.datasource.HttpClient;

public class DefaultHttpClient
implements HttpClient {
    @Override
    public String fetch(URI uri, AtomFeedProperties atomFeedProperties, Map<String, String> clientCookies) {
        StringBuilder stringBuilder;
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)uri.toURL().openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept", "application/atom+xml");
            connection.addRequestProperty("User-Agent", "Mozilla");
            ClientCookies cookies = new ClientCookies(clientCookies);
            String httpRequestPropertyValue = cookies.getHttpRequestPropertyValue();
            if (httpRequestPropertyValue != null) {
                connection.setRequestProperty("Cookie", httpRequestPropertyValue);
            }
            connection.setDoOutput(true);
            connection.setConnectTimeout(atomFeedProperties.getConnectTimeout());
            connection.setReadTimeout(atomFeedProperties.getReadTimeout());
            connection.setInstanceFollowRedirects(false);
            boolean shouldHandleRedirection = atomFeedProperties.isHandleRedirection();
            stringBuilder = this.execute(connection, shouldHandleRedirection, atomFeedProperties, httpRequestPropertyValue, uri.toString());
        }
        catch (Exception e) {
            throw new AtomFeedClientException(e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return stringBuilder.toString();
    }

    private HttpURLConnection followRedirect(AtomFeedProperties atomFeedProperties, HttpURLConnection connection, String httpRequestPropertyValue) throws IOException {
        String redirectedUrl = connection.getHeaderField("Location");
        String returnedCookie = connection.getHeaderField("Set-Cookie");
        connection.disconnect();
        System.out.println("Redirect to URL : " + redirectedUrl);
        connection = (HttpURLConnection)new URL(redirectedUrl).openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/atom+xml");
        connection.addRequestProperty("User-Agent", "Mozilla");
        if (returnedCookie == null || "".equals(returnedCookie)) {
            if (httpRequestPropertyValue != null) {
                connection.setRequestProperty("Cookie", httpRequestPropertyValue);
            }
        } else {
            connection.setRequestProperty("Cookie", returnedCookie);
        }
        connection.setDoOutput(true);
        connection.setConnectTimeout(atomFeedProperties.getConnectTimeout());
        connection.setReadTimeout(atomFeedProperties.getReadTimeout());
        return connection;
    }

    private StringBuilder execute(HttpURLConnection connection, boolean shouldHandleRedirection, AtomFeedProperties atomFeedProperties, String httpRequestPropertyValue, String url) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        connection.connect();
        int responseCode = connection.getResponseCode();
        boolean redirect = false;
        redirect = this.isRedirectResponse(responseCode);
        if (responseCode >= 200 && responseCode < 300) {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            stringBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line + '\n');
            }
        } else if (redirect && shouldHandleRedirection) {
            HttpURLConnection redirectConnection = this.followRedirect(atomFeedProperties, connection, httpRequestPropertyValue);
            stringBuilder = this.execute(redirectConnection, false, atomFeedProperties, httpRequestPropertyValue, url);
        } else {
            if (responseCode == 404) {
                throw new RuntimeException(String.format("Resource not found at %s", url));
            }
            if (responseCode == 401) {
                throw new RuntimeException("User not authorized");
            }
            throw new RuntimeException(String.format("Unexpected response status %d", responseCode));
        }
        return stringBuilder;
    }

    private boolean isRedirectResponse(int responseCode) {
        boolean redirect = false;
        if (responseCode == 302 || responseCode == 303) {
            redirect = true;
        }
        return redirect;
    }
}

